//  $Id: RtConfig.hh 1.6.1.1.1.4 Mon, 02 Feb 1998 18:26:49 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef RTCONFIG_H
#define RTCONFIG_H

#include "config.hh"
#include <Pix.h>
#include "Route.hh"
#include "aut-num.hh"
#include "Error.hh"

#define EXPORT_COMMAND        0
#define IMPORT_COMMAND        1
#define NETWORKS_COMMAND      2
#define DEFAULT_COMMAND       3
#define PKT_FILTER_COMMAND    4
#define OUTBOUND_PKT_FILTER_COMMAND   5

extern void (*config)(int, Pix=NULL, Pix=NULL, Pix=NULL, Pix=NULL, char * =NULL);

void   rsd_process_line(int, Pix, Pix, Pix, Pix, char *);
void gated_process_line(int, Pix, Pix, Pix, Pix, char *);
void cisco_process_line(int, Pix, Pix, Pix, Pix, char *);

extern int  cisco_access_list_no;
extern int  cisco_max_preference;
extern int  cisco_aspath_access_list_no;
extern char cisco_map_name[80];
extern int cisco_map_inc;
extern int cisco_map_first_no;
extern char cisco_neighbor_address[80];
extern int  opt_force_match_ip_inbound;
extern int  opt_cisco_access_list_cache;
extern Error error;
extern char *opt_prompt;
extern int  opt_cisco_supress_martian;
extern int opt_cisco_compress_acls;

#endif // RTCONFIG_H
