//  $Id: f_rsd.cc 1.4.2.6 Mon, 02 Feb 1998 18:26:49 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)


#include "config.hh"
#include <cstring>
#include <iostream.h>
#include <iomanip.h>
#include <cctype>
#include "RtConfig.hh"
#include "Node.h"

#define DBG_RSD 7

static char *rsd_PRFX_format(Pix i) {
   static char buffer[128];
   Prefask &address = Prefask_map(i);

   int2quad(buffer, address.get_prefix());
   sprintf(buffer+strlen(buffer), " masklen %u exact", address.get_length());

   return buffer;
}

void rsd_print_as_path(SetOfASPath &re) {
   regexp *reg = reg->construct(re.re->m);
   cout << "<" << *reg << ">";
}

void rsd_print_net_list(SetOfPrefix &nets, int pref, int med, int dpa) {
   if (nets.empty())
      return;

   RadixSet::SortedPrefixIterator itr(&nets.members);
   u_int addr;
   u_int leng;
   char buffer[64];

   for (bool ok = itr.first(addr, leng);
	ok;
	ok = itr.next(addr, leng)) {
      cout << "   " << int2quad(buffer, addr) 
	   << " masklen " << leng << " exact";
      if (pref < 0)
	 cout << "\trestrict;\n";
      else {
	 cout << "\tpreference " << pref;
	 if (med != -2)
	    cout << " MED " << med;
	 if (dpa != -2)
	    cout << " DPA " << dpa;
	 cout << ";\n";
      }
   }
}

class f_rsd_node {
public:
   f_rsd_node() : result(this) {}
   SetOfASPath  as_path;
   int          contains;

   ListNode     result;
};

class Result {
public:
   Result() : rlist(this) {
      ne = NULL;
   }
   ~Result() {
      if (ne)
	 delete ne;
   }
    
   SetOfASPath* as_path() {
      if (ne && ne->first())
	 return &ne->first()->as_path;
      return NULL;
   }

   SetOfPrefix* prfx_set() {
      if (ne && ne->first())
	 return &ne->first()->prfx_set;
      return NULL;
   }

   NormalExpression *ne;
   int pref;
   int med;
   int dpa;

   ListNode rlist;
};

static int add(ListHead<Result> *rlist,
	       NormalExpression *ne1, NormalExpression *ne2, 
	       NormalExpression *ne3, NormalExpression *ne4, 
	       ActionNode *action1, ActionNode *action2, 
	       ActionNode *action3, ActionNode *action4, 
	       intintVHMap &pref_map1, intintVHMap &pref_map2) {
   int last = 0;
   extern int get_pref(ActionNode *action1, ActionNode *action2, 
		       intintVHMap &pref_map1, intintVHMap &pref_map2);
   extern int get_med(ActionNode *action3, ActionNode *action4);
   extern int get_dpa(ActionNode *action3, ActionNode *action4);

   ne1->do_and(*ne2);
   ne1->do_and(*ne3);
   ne1->do_and(*ne4);

   // Added by wlee
   delete ne2;
   delete ne3;
   delete ne4;

   if (ne1->empty()) 
      {
      delete ne1;
      return last;
      }

   if (ne1->universal()) 
      last = 1;

   for (NormalTerm *nt = ne1->first(); nt; nt = ne1->next()) {
      Result *r = new Result;
      r->ne = new NormalExpression;
      *(r->ne) += new NormalTerm(*nt);
      r->pref = get_pref(action1, action2, pref_map1, pref_map2);
      r->med  = get_med(action3, action4);
      r->dpa  = get_dpa(action3, action4);
      rlist->append(r->rlist);
   }
   delete ne1;

   return last;
}
regexp *rsd_convert_re_bol(regexp *r, int asno) {
   switch (r->regexp_type) {
   case REGEXP_BOL : 
      {
	 regexp_cat *n = new regexp_cat;
	 n->left = r;
	 n->right = new regexp_symbol;
	 ((regexp_symbol *) (n->right))->add(asno, asno);
	 r = n;
      }
      break;
   case REGEXP_STAR :
      ((regexp_star *) r)->left = 
       rsd_convert_re_bol(((regexp_star *) r)->left, asno);
      break;
   case REGEXP_QUESTION :
      ((regexp_question *) r)->left = 
       rsd_convert_re_bol(((regexp_question *) r)->left, asno);
      break;
   case REGEXP_PLUS :
      ((regexp_plus *) r)->left = 
       rsd_convert_re_bol(((regexp_plus *) r)->left, asno);
      break;
   case REGEXP_CAT :
      ((regexp_cat *) r)->left = 
       rsd_convert_re_bol(((regexp_cat *) r)->left, asno);
      ((regexp_cat *) r)->right = 
       rsd_convert_re_bol(((regexp_cat *) r)->right, asno);
      break;
   case REGEXP_OR :
      ((regexp_or *) r)->left = 
       rsd_convert_re_bol(((regexp_or *) r)->left, asno);
      ((regexp_or *) r)->right = 
       rsd_convert_re_bol(((regexp_or *) r)->right, asno);
      break;
   default :
      ;
   }
   return r;
}

FilterNode *rsd_convert_bol(FilterNode *n, int asno) {
   switch (n->type) {
   case T_ANDNode:
      rsd_convert_bol(((ANDNode *) n)->left, asno);
      rsd_convert_bol(((ANDNode *) n)->right, asno);
      break;
   case T_ORNode:
      rsd_convert_bol(((ORNode *) n)->left, asno);
      rsd_convert_bol(((ORNode *) n)->right, asno);
      break;
   case T_NotNode:
      rsd_convert_bol(((NotNode *) n)->left, asno);
      break;
   case T_ASPathNode:
      ((ASPathNode *) n)->re = rsd_convert_re_bol(((ASPathNode *) n)->re, asno);
      break;
   default:
      ;
   }
   return n;
}

void rsd_process_line(int command, 
		      Pix asno, Pix addr, Pix peer_asno, Pix peer_addr, 
		      char *name) {
/*
  cout << command 
        << ": "
        << AS_map(asno) 
        << " " 
        << Prefask_map(addr) 
        << " " 
        << AS_map(peer_asno) 
        << " " 
        << Prefask_map(peer_addr) 
        << endl;
*/
   if (command != IMPORT_COMMAND) {
      cerr << "Error: Unknown RtConfig command." << endl;
      return;
   }
      
   // disabling printing AS before AS numbers
   re_asno_t no;
   no.prefix_str = "";

   ASPolicy *p, *p_peer;
   Filter_Action *fap, *fap2, *fap_peer;
   Filter_Action *ifap, *ifap_peer;
   InterASPolicy *ip, *ip2, *ip_peer;
   AutNum *autnum, *autnum_peer;

   ////////////////////////////// importing as //////////////////////////////

   // define as
   if (!(autnum = AS_map.define(asno))) {
      cerr << "Error: no object for " << AS_map(asno) << endl;
      return;
    }

   // find peer as
   if (!(p = autnum->find_peer(peer_asno))) {
      cerr << "Error: " << AS_map(asno) 
	 << " has no policy for " << AS_map(peer_asno) << endl;
      return;
   }

   if (!(fap = p->in.head())) {
      cerr << "Error: " << AS_map(asno) 
	 << " has no import policy for " << AS_map(peer_asno) << endl;
      return;
   }

   // find peering
   ip = p->find_peering(addr, peer_addr);
   
   ////////////////////////////// exporting as //////////////////////////////

   // define as
   if (!(autnum_peer = AS_map.define(peer_asno))) {
      cerr << "Error: no object for " << AS_map(peer_asno) << endl;
      return;
    }
   
   // find peer as
   if (!(p_peer = autnum_peer->find_peer(asno))) {
      cerr << "Error: " << AS_map(peer_asno) 
	 << " has no policy for " << AS_map(asno) << endl;
      return;
   }

   if (!(fap_peer = p_peer->out.head())) {
      cerr << "Error: " << AS_map(peer_asno) 
	 << " has no export policy for " << AS_map(asno) << endl;
      return;
   }
   
   // find peering
   ip_peer = p_peer->find_peering(peer_addr, addr);
   
   //////////////////////////////////////////////////////////////////////////

   // convert the policies of exporting as so that ^ is replaced by ^ASno
   for (fap2 = p_peer->out.head(); fap2; fap2=p_peer->out.next(fap2->falist))
      rsd_convert_bol(fap2->filter, atoi(AS_map(peer_asno)+2));
   for (ip2=p_peer->interas.head(); ip2; ip2=p_peer->interas.next(ip2->interas))
      for (fap2 = ip2->out.head(); fap2; fap2 = ip2->out.next(fap2->falist))   
	 rsd_convert_bol(fap2->filter, atoi(AS_map(peer_asno)+2));

   int last = 0;
   ListHead<Result> rlist;
   // make rlist contain a list of (ne, pref) pairs
   // that will be imported

   // for each as-out policy
   for (; fap_peer && !last; fap_peer = p_peer->out.next(fap_peer->falist)) {
      if (ip_peer) // is there an interas-out policy
	 // for each interas-out policy
	 for (ifap_peer = ip_peer->out.head(); 
	      ifap_peer && !last; 
	      ifap_peer = ip_peer->out.next(ifap_peer->falist))
	    // for each as-in policy
	    for (fap = p->in.head(); 
		 fap && !last; 
		 fap = p->in.next(fap->falist)) {
	       // calculate imports for this interface
	       if (ip) // is there an interas-in policy
		  // for each interas-in policy
		  for (ifap = ip->in.head(); 
		       ifap && !last; 
		       ifap = ip->in.next(ifap->falist))
		     last = add(&rlist, 
				new NormalExpression(*fap->expand()), 
				new NormalExpression(*ifap->expand()), 
				new NormalExpression(*fap_peer->expand()), 
				new NormalExpression(*ifap_peer->expand()), 
				fap->action, ifap->action, 
				fap_peer->action, ifap_peer->action,
				autnum->pref_map, p->ipref_map);
      
	       if (!last) // left over policies
		  last = add(&rlist, 
			     new NormalExpression(*fap->expand()), 
			     new NormalExpression(*p->get_remaining_in()), 
			     new NormalExpression(*fap_peer->expand()), 
			     new NormalExpression(*ifap_peer->expand()), 
			     fap->action, NULL, 
			     fap_peer->action, ifap_peer->action,
			     autnum->pref_map, p->ipref_map);
	    }
      if (!last) // left over out policies
	 // for each as-in policy
	 for (fap = p->in.head(); 
	      fap && !last; 
	      fap = p->in.next(fap->falist)) {
	    // calculate imports for this interface
	    if (ip) // is there an interas-in policy
	       // for each interas-in policy
	       for (ifap = ip->in.head(); 
		    ifap && !last; 
		    ifap = ip->in.next(ifap->falist))
		  last = add(&rlist, 
			     new NormalExpression(*fap->expand()), 
			     new NormalExpression(*fap->expand()), 
			     new NormalExpression(*fap_peer->expand()), 
			     new NormalExpression(*p_peer->get_remaining_out()),
			     fap->action, ifap->action, 
			     fap_peer->action, NULL,
			     autnum->pref_map, p->ipref_map);

	    if (!last) // left over policies
	       last = add(&rlist, 
			  new NormalExpression(*fap->expand()), 
			  new NormalExpression(*p->get_remaining_in()), 
			  new NormalExpression(*fap_peer->expand()), 
			  new NormalExpression(*p_peer->get_remaining_out()),
			  fap->action, NULL, 
			  fap_peer->action, NULL,
			  autnum->pref_map, p->ipref_map);
	 }
   }    

   if (rlist.is_empty())
      return;

   if (rlist.size() > 32) {
      cerr << "Error: expression is too complicated for rsd, contains more than 32 (as-path expression, netlist, pref) triplets, which may cause billions of rsd import/export statements..." << endl;
      rlist.clear();
      return;
   }

   // with n (as-path expression, netlist, pref) triplets
   // we have to generate 2^n-1 rsd import statements
   // because rsd stops after first as path match
   // Sep 5, 1995
   // rsd now has continue statement. So above statement is no longer true.
   // However, we are not going to take advantage of it for the time being.

   ListHead<f_rsd_node> result;
   f_rsd_node *node, *nptr;
   unsigned int fill;
   unsigned int i;
   Result *r;

   for (i = 1, r = rlist.head(); r; r = rlist.next(r->rlist), i <<= 1) {
      for (nptr = result.head(); nptr; nptr = result.next(nptr->result))
	 if (r->as_path() && nptr->as_path == *r->as_path())
	    break;
      if (nptr)
	 nptr->contains |= i;
      else {
	 node = new f_rsd_node;
	 node->as_path = *r->as_path();
	 node->contains = i;
	 result.append(node->result);
      }
      Debug(Channel(DBG_RSD) << hex << i << "\n");
   }

   for (nptr = result.head(); nptr; nptr = result.next(nptr->result)) {
      for (fill = 0, i = 1, r = rlist.head(); 
	   r; 
	   r = rlist.next(r->rlist), fill |= i, i <<= 1) {
	 Debug(Channel(DBG_RSD) << nptr->contains << " " << i << " ");
	 if (!(nptr->contains & i) && !(nptr->contains & fill)) {
	    node = new f_rsd_node;
	    node->as_path = nptr->as_path;
	    node->as_path &= *r->as_path();
	    if (!node->as_path.empty()) {
	       node->contains = nptr->contains | i;
	       result.append(node->result);
	       Debug(Channel(DBG_RSD) << hex << node->contains);
	    } else
	       delete node;
	 }
	 Debug(Channel(DBG_RSD) << "\n");
      }
   }

   SetOfASPath as_path_covered, tmp_as_path;

   for (nptr = result.tail(), last = 0; 
	nptr && !last; 
	nptr = result.prev(nptr->result)) {
      if (!nptr->as_path.universal()) {
	 tmp_as_path = as_path_covered;
	 ~tmp_as_path;
	 nptr->as_path &= tmp_as_path;
      }
      if (!nptr->as_path.empty()) {
	 tmp_as_path = nptr->as_path;
	 as_path_covered |= tmp_as_path;
	 last = as_path_covered.universal();
	 cout << "import proto bgp ";
	    
	 if (result.size() == 1 && nptr->as_path.universal())
	    cout << "as " << (AS_map(peer_asno) + 2) << " {\n";
	 else {
	    cout << "aspath ";
	    rsd_print_as_path(nptr->as_path);
	    cout << " origin any {\n";
	 }

	 // now print the network lists
	 SetOfPrefix nets_covered;	 
	 int all_pref = -1;
	 int all_med  = -2;
	 int all_dpa  = -2;
	 int include;
	 SetOfPrefix prfx;
	 for (include = nptr->contains, r = rlist.head();
	      r; 
	      r = rlist.next(r->rlist), include >>= 1)
	    if (include & 1) {
	       prfx = *r->prfx_set();
	       ~nets_covered;
	       prfx &= nets_covered;
	       ~nets_covered;
	       if (!prfx.empty()) {
		  nets_covered |= prfx;
		  if (all_pref == -1 
		      && (nets_covered.negated() || nets_covered.universal())) {
		     all_pref = r->pref;
		     all_med  = r->med;
		     all_dpa  = r->dpa;
		  } else 
		     rsd_print_net_list(prfx, r->pref, r->med, r->dpa);
	       }
	    }
	 if (all_pref == -1) 
	    cout << "   all restrict;\n";
	 else {
	    if (nets_covered.negated()) {
	       ~nets_covered;
	       rsd_print_net_list(nets_covered, -1, -2, -2);
	    }
	    cout << "   all preference " << all_pref;
	    if (all_med != -2)
	        cout << " MED " << all_med;
	    if (all_dpa != -2)
	        cout << " DPA " << all_dpa;
	    cout << ";\n";
	 }
	 cout << "};\n\n";
      }
   }

   result.clear();
   rlist.clear();
}
