%{
//  $Id: xx_parser.y 1.3 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"

#include <cstring>
#include <cstdlib>
#include <cctype>
#include <cstdarg>

extern "C" {
#if HAVE_MEMORY_H && 0
#   include <memory.h>
#endif
#ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#endif
}

#include "whois.hh"
#include "Node.h"

#include "ASMacroMap.h"    
#include "ASMap.h"         
#include "CommunityMap.hh"  
#include "RegisterMap.hh"  
#include "PrefaskMap.hh"  
#include "Error.hh"  
#include "regexp.hh"
#include "peval.hh"

Error parser_error;

Whois *parser_db_ptr;

extern int yyerror(char *);
extern int yylex();

static regexp_symbol *re_symbol;

%}

%union {
   int i;
   char *val;
   FilterNode *node_ptr;
   NetListNode *netlistnode_ptr;
   regexp *re;
   Pix pi;
}

%token <val> FROM_TKN         258
%token <val> ASPATH_TKN       272
%token <val> ACCEPT_TKN       259
%token <pi>  PRFMSK_TKN       260
%token <val> NUM_TKN          262
%token <pi>  ASNUM_TKN        263
%token <pi>  ASMACRO_TKN      265
%token <pi>  CNAME_TKN        266
%token <val> ERROR_TKN        267
%token <val> ANY_TKN          268
%left  <val> OR_TKN           269
%left  <val> AND_TKN          270
%right <val> NOT_TKN          271
%token <val> TEXT_TKN         273
%token <val> IGP_TKN          274
%token <val> MED_TKN          275
%token <val> SET_TKN          276
%token <pi>  REGISTER_TKN     277
%token <val> PREF_TKN         278

%type <node_ptr> rpe
%type <node_ptr> rpe_term
%type <node_ptr> rpe_factor
%type <node_ptr> operand
%type <netlistnode_ptr> netlist
%type <re> aspathexp
%type <re> aspathre
%type <re> aspathre_term
%type <re> aspathre_closure
%type <re> aspathre_factor
%type <re> aspathre_no
%type <re> aspathre_range
%type <re> aspathre_subrange

%%
input_stream: {
   if (opt_prompt)
      cout << opt_prompt;
}
| input_stream input {
   if (opt_prompt)
      cout << opt_prompt;
}
;

input: input_line '\n'
| error '\n' {
   cerr << "Error: ";
   parser_error.order(InOrder);
   parser_error.warning("");	/* ??? what should this be ? */
   //parser_error.printOrder(PRINT_INORDER); /* as opposed to reverse */
   //parser_error.warning();
}
| '\n'
;

input_line: policy_line
;

policy_line: rpe
{
   evaluate($1);
   delete $1;
}
| SET_TKN REGISTER_TKN rpe 
{
   AssignNode *n = new AssignNode($2, $3);
   evaluate(n);
   delete n;
}
;

rpe: rpe OR_TKN rpe_term
{
   $$ = new ORNode($1, $3);
}
| rpe rpe_term %prec OR_TKN
{
   $$ = new ORNode($1, $2);
}
| rpe_term
;

rpe_term : rpe_term AND_TKN rpe_factor
{
   $$ = new ANDNode($1, $3);
}
|
rpe_factor
;

rpe_factor :  NOT_TKN rpe_factor
{
   $$ = new NotNode($2);
}
| '(' rpe ')'
{
   $$ = $2;
}
| operand 
;

operand: ASNUM_TKN
{
   $$ = new ASNode( $1 );
}
| ASMACRO_TKN
{
   $$ = new ASMacroNode( $1 );
}
| CNAME_TKN
{
   $$ = new CommNode( $1 );
}
| ANY_TKN
{
   $$ = new ANYNode;
}
| '{' netlist '}' 
{ 
   $$ = $2; 
}
| aspathexp
{
   $$ = new ASPathNode( $1 );
}
| REGISTER_TKN 
{
   $$ = new RegisterNode($1);
}
;

netlist: PRFMSK_TKN
{
   $$ = new NetListNode;
   $$->add($1);
}
| netlist ',' PRFMSK_TKN
{
   ($$ = $1)->add($3);
}
;

aspathexp:  '<' aspathre '>' {
   $$ = $2;
} 
| '<' error '>' {
   $$ = new regexp_empty_set;
   cerr << "Error: invalid as path expression\n";
}
;

aspathre: aspathre '|' aspathre_term {
   $$ = new regexp_or($1, $3);
}
| aspathre_term
;

aspathre_term: aspathre_term aspathre_closure {
   $$ = new regexp_cat($1, $2);
}
| aspathre_closure
;

aspathre_closure: aspathre_closure '*' {
   $$ = new regexp_star($1);
}
| aspathre_closure '?' {
   $$ = new regexp_question($1);
}
| aspathre_closure '+' {
   $$ = new regexp_plus($1);
}
| aspathre_factor
;

aspathre_factor: aspathre_no {
   $$ = $1;
}
| '^' {
   $$ = new regexp_bol();
}
| '$' {
   $$ = new regexp_eol();
}
| '(' aspathre ')' {
   $$ = $2;
}
;

aspathre_no: ASNUM_TKN {
   $$ = new regexp_symbol(REGEXP_SYMBOL_AS_NO, $1);
}
| '.' {
   $$ = new regexp_symbol(REGEXP_SYMBOL_ANY);
}
| '[' aspathre_range ']' {
   $$ = $2;
}
| '[' '^' aspathre_range ']' {
   $$ = $3;
   ((regexp_symbol *) $$)->complement();
}
| ASMACRO_TKN {
   $$ = new regexp_symbol(REGEXP_SYMBOL_AS_MACRO, $1);
}
;

aspathre_range: {
   $$ = re_symbol = new regexp_symbol;
}
| aspathre_range aspathre_subrange {
   $$ = $1;
}
;

aspathre_subrange: ASNUM_TKN {
   re_symbol->add(REGEXP_SYMBOL_AS_NO, $1);
}
| '.' {
   re_symbol->add(REGEXP_SYMBOL_ANY);
}
| ASNUM_TKN '-' ASNUM_TKN {
   re_symbol->add(REGEXP_SYMBOL_AS_NO, $1, $3);
}
| ASMACRO_TKN {
   re_symbol->add(REGEXP_SYMBOL_AS_MACRO, $1);
}
;

%%

extern char *yytext;

int yyerror(char *s) {
   parser_error = 1; 
   return(0);
}

