//  $Id: RtConfig.cc 1.8.1.1.1.1 Mon, 26 Jan 1998 17:26:49 -0800 cengiz $
//
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#include "config.hh"
#include <cstdlib>

extern "C" {
#if HAVE_UNISTD_H
#   include <unistd.h>
#endif
}
#include <iostream.h>
#include <iomanip.h>
#include "dbase.hh"
#include "Node.h"
#include "debug.hh"
#include "trace.hh"
#include "rusage.hh"
#include "RtConfig.hh"
#include "Argv.hh"
#include "version.hh"

Rusage ru;

int  opt_rusage                  = 0;
char *opt_prompt                 = "RtConfig> ";
int  opt_config                  = 0;
int  opt_force_match_ip_inbound  = 0;
int  opt_cisco_access_list_cache = 1;
int  opt_cisco_supress_martian   = 0;
int  opt_cisco_compress_acls     = 0;

typedef struct {
   char *name;
   void (*process_line)(int, Pix, Pix, Pix, Pix, char *);
} config_format_type;

config_format_type config_formats[] = {
   { "gated",       gated_process_line },
   { "cisco",       cisco_process_line },
   { "rsd",         rsd_process_line },
   { "", 0 }
};

void (*config)(int, Pix=NULL, Pix=NULL, Pix=NULL, Pix=NULL, char * =NULL) 
   = cisco_process_line;

int start_tracing(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      trace.enable(nextArg);
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0; 
}

int start_debugging(char *dst, char *key, char *nextArg) {
   if (nextArg) {
      Debug(dbg.enable(atoi(nextArg)));
      return 1; // return 1 to signify nextArg is used by us
   }
   return 0;
}

int select_config_format(char *dst, char *key, char *nextArg) {
   if (!nextArg)
      return 0;

   for (opt_config = 0; *config_formats[opt_config].name; opt_config++)
      if (strcmp(nextArg, config_formats[opt_config].name) == 0)
	 break;
   if (! *config_formats[opt_config].name) {
      cerr << "Error: config file format '" << nextArg << "' is not supported..." << endl;
      exit(1);
   }
   config = config_formats[opt_config].process_line;

   return 1; // return 1 to signify nextArg is used by us
}

void init_and_set_options (int argc, char **argv, char **envp) {
   ArgvInfo argTable[] = {
     // RAToolSet common arguments
     // key, type, src, dst, help
     {"-T", ARGV_FUNC, (char *) &start_tracing,      (char *) NULL, 
      "Start tracing the next argument"},
     {"-D", ARGV_FUNC, (char *) &start_debugging,    (char *) NULL, 
      "Start debugging the next argument"},
     {"-version", ARGV_FUNC, (char *) &version,      (char *) NULL,
      "Show version"},
     {"-h", ARGV_FUNC, (char *) &Whois::ArgvHost,    (char *) NULL,
      "Host name of the RAWhoisd server"},
     {"-p", ARGV_FUNC, (char *) &Whois::ArgvPort,    (char *) NULL,
      "Port number of the RAWhoisd server"},
     {"-s", ARGV_FUNC, (char *) &Whois::ArgvSources, (char *) NULL,
      "Order of databases"},
     {"-rusage", ARGV_CONSTANT, (char *) 1,          (char *) &opt_rusage,
      "On termination print resource usage"},
     {"-prompt", ARGV_STRING,  (char *) NULL,        (char *) &opt_prompt,
      "Prompt"},
     {"-ignore_errors", ARGV_FUNC, (char *)&Whois::IgnoreErrors, (char *)NULL,
      "Ignore IRR error and warning messages"},
     {"-report_errors", ARGV_FUNC, (char *)&Whois::ReportErrors, (char *)NULL,
      "Print IRR error and warning messages"},
     
     {"-config", ARGV_FUNC, (char *) &select_config_format, (char *) NULL, 
      "Configuration format (cisco, gated or rsd)"},
     {"-force_match_ip_inbound", ARGV_CONSTANT, 
      (char *) 1, (char *) &opt_force_match_ip_inbound,
      "Produce a match ip clause for inbound maps.\n\t\t\t\tCisco only."},
     {"-disable_access_list_cache", ARGV_CONSTANT, 
      (char *) 0, (char *) &opt_cisco_access_list_cache,
      "Do not reuse the old access list numbers.\n\t\t\t\tCisco only."},
     {"-supress_martian", ARGV_CONSTANT, 
      (char *) 1, (char *) &opt_cisco_supress_martian,
      "Generate access lists supressing invalid routes.\n\t\t\t\tCisco only."},
     {"-cisco_compress_acls", ARGV_CONSTANT, 
      (char *) 1, (char *) &opt_cisco_compress_acls,
      "Combine multiple cisco access list lines into a single line using wildcards whenever possible.\n\t\t\t\tCisco only."},
     
     {(char *) NULL, ARGV_END, (char *) NULL, (char *) NULL,
      (char *) NULL}
   };
   
   for (char **p = envp; *p != NULL; p++) {
      if (strncmp(*p, "IRR_HOST=", 9) == 0)  {
	 whois.SetDefaultHost(*p + 9);
         continue;
      }
      if (strncmp(*p, "IRR_PORT=", 9) == 0)  {
	 whois.SetDefaultPort(atoi(*p + 9));
         continue;
      }
      if (strncmp(*p, "IRR_SOURCES=", 12) == 0)  {
	 whois.SetDefaultSources(*p + 12);
         continue;
      }
   }

   if (ParseArgv(&argc, argv, argTable, ARGV_NO_LEFTOVERS) != ARGV_OK) {
      cerr << endl;
      exit(1);
   }

   // have a prompt only if the input is coming from a tty
   if (!isatty(fileno(stdin)) || !isatty(fileno(stdout)))
      opt_prompt = NULL;
}

main(int argc, char **argv, char **envp) {
   extern int xxparse();

   init_and_set_options(argc, argv, envp);
   regexp::expand_AS_macros();

   xxparse();
   
   if (opt_prompt)
      cout << endl;

   if (opt_rusage)
      clog << ru;

}

