//  $Id: bgp_aspath.cc 1.2 Fri, 18 Jul 1997 15:59:18 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): WeeSan Lee (wlee@isi.edu)


#if !defined(IDENT_OFF)
#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7) 
static char ident[] = 
   "@(#)$Id: bgp_aspath.cc 1.2 Fri, 18 Jul 1997 15:59:18 -0700 wlee $";
#endif
#endif


#include <cstdio>
#include "bgp_aspath.hh"
#include "ASMap.h"      // To include AS_map global variable

Pix BgpASPath::contain(char *pzcASNo)
{
   Pix pix = AS_map.seek(pzcASNo);
   // If not defined in AS_map, definately not exist before.
   if (!pix) return NULL; 
   // Otherwise, check the FirstAndLastAS list. 
   // It is possible that AS # has been defined in AS_map 
   // before being added into list.
/*
   for (FirstAndLastAS *pcFirstAndLastAS = cFirstAndLastASes.head();
	pcFirstAndLastAS;
	pcFirstAndLastAS = cFirstAndLastASes.next(pcFirstAndLastAS->cNode))
      if (pcFirstAndLastAS->pvFirst == pix) return pix;
*/
   if (find(pix)) return pix;
   return NULL;
}

void BgpASPath::addFirst(char *pzcFirst)
{
   if (contain(pzcFirst)) return;
   Pix pvFirst = AS_map.add_entry(pzcFirst);
   FirstAndLastAS *pcFirstAndLastAS = new FirstAndLastAS;
   pcFirstAndLastAS->pvFirst = pvFirst;
   cFirstAndLastASes.append(pcFirstAndLastAS->cNode);
}

void BgpASPath::addLast(char *pzcFirst, char *pzcLast)
{
   Pix pvFirst = AS_map.seek(pzcFirst);
   if (!pvFirst) return;  // Shouldn't happen!
   FirstAndLastAS *pcFirstAndLastAS;
   for (pcFirstAndLastAS = cFirstAndLastASes.head(); 
	pcFirstAndLastAS; 
	pcFirstAndLastAS = cFirstAndLastASes.next(pcFirstAndLastAS->cNode))
      if (pcFirstAndLastAS->pvFirst == pvFirst) break;
   if (!pcFirstAndLastAS) return;  // Shouldn't happen!
   pcFirstAndLastAS->pvLast.add(AS_map.add_entry(pzcLast));
}

// Check if every entry got last peer, if not, duplicate the first peer as last
void BgpASPath::verify(void)
{
   FirstAndLastAS *pcFirstAndLastAS;
   for (pcFirstAndLastAS = cFirstAndLastASes.head(); 
	pcFirstAndLastAS; 
	pcFirstAndLastAS = cFirstAndLastASes.next(pcFirstAndLastAS->cNode))
      if (pcFirstAndLastAS->pvLast.empty())
	 pcFirstAndLastAS->pvLast.add(pcFirstAndLastAS->pvFirst);
}

FirstAndLastAS *BgpASPath::find(Pix pvFirst)
{
   for (FirstAndLastAS *pcFirstAndLastAS = cFirstAndLastASes.head();
	pcFirstAndLastAS;
	pcFirstAndLastAS = cFirstAndLastASes.next(pcFirstAndLastAS->cNode))
      if (pcFirstAndLastAS->pvFirst == pvFirst) return pcFirstAndLastAS;
   return NULL;
}

void BgpASPath::print(void)
{
   FirstAndLastAS *pcFirstAndLastAS;
   for (pcFirstAndLastAS = cFirstAndLastASes.head(); 
	pcFirstAndLastAS; 
	pcFirstAndLastAS = cFirstAndLastASes.next(pcFirstAndLastAS->cNode))
      {
      printf("%s --", AS_map(pcFirstAndLastAS->pvFirst));
      for (Pix pix = pcFirstAndLastAS->pvLast.first(); 
	   pix; 
	   pcFirstAndLastAS->pvLast.next(pix))
	 printf(" %s", AS_map(pcFirstAndLastAS->pvLast(pix))); 
      printf("\n");
      }
}
