/*  $Id: bgp_dump.l 1.3 Fri, 18 Jul 1997 15:59:18 -0700 wlee $
 
  Copyright (c) 1994 by the University of Southern California
  and/or the International Business Machines Corporation.
  All rights reserved.

  Permission to use, copy, modify, and distribute this software and
  its documentation in source and binary forms for lawful
  non-commercial purposes and without fee is hereby granted, provided
  that the above copyright notice appear in all copies and that both
  the copyright notice and this permission notice appear in supporting
  documentation, and that any documentation, advertising materials,
  and other materials related to such distribution and use acknowledge
  that the software was developed by the University of Southern
  California, Information Sciences Institute and/or the International
  Business Machines Corporation.  The name of the USC or IBM may not
  be used to endorse or promote products derived from this software
  without specific prior written permission.

  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
  NON-INFRINGEMENT.

  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
  THE USE OR PERFORMANCE OF THIS SOFTWARE.

  Questions concerning this software should be directed to 
  info-ra@isi.edu.

  Author(s): WeeSan Lee (wlee@isi.edu) */


%{

#if !defined(IDENT_OFF)
#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7) 
static char ident[] = 
   "@(#)$Id: bgp_dump.l 1.3 Fri, 18 Jul 1997 15:59:18 -0700 wlee $";
#endif
#endif

#include <string.h>
#include "bgp_aspath.hh"

#undef YY_DECL
#define YY_DECL int loadBgpDump(BgpASPath &rBgpASPath)


static int iBgpASPathCol = 0;
static int iCol = 1;
static int iRow = 1;

static int iFirstPeer = 1;
char pzcFirstPeer[32];
char pzcCandidateLastPeer[32];

%}

%x AS_PATH
%x USEFUL_LINE

%%
.  { 
   iCol++;
}

\n {
   iCol = 1;
   iRow++;
}

Path {
   iBgpASPathCol = iCol - 1;   // (iCol - 1) should be a space
   BEGIN USEFUL_LINE;
}

<USEFUL_LINE>. {
   if (++iCol == iBgpASPathCol) {
      iFirstPeer = 1;
      pzcFirstPeer[0] = 0;
      pzcCandidateLastPeer[0] = 0;
      BEGIN AS_PATH;
   }
}

<USEFUL_LINE>\n {
   iCol = 1;
   iRow++;
}

<AS_PATH>[ ][1-9][0-9]*[ ] {  // Match a number not starting with a zero
   yyless(yyleng - 1);        // Push back the trailer blank
   if (iFirstPeer) {
//      printf("%d:%d - AS%s ", iRow, iCol, yytext + 1);
      sprintf(pzcFirstPeer, "AS%s", yytext + 1);
      iFirstPeer = 0;
      rBgpASPath.addFirst(pzcFirstPeer);
   } else {
      sprintf(pzcCandidateLastPeer, "AS%s", yytext + 1);
   }
}

<AS_PATH>. ;

<AS_PATH>\n {
//   printf("%s\n", pzcCandidateLastPeer);
   if (pzcCandidateLastPeer[0]) 
      rBgpASPath.addLast(pzcFirstPeer, pzcCandidateLastPeer);
   iCol = 1;
   iRow++;
   BEGIN USEFUL_LINE;
}


%%

int yywrap(void) 
{
   return 1;
}

#ifdef DEBUG

void main(void)
{
   while (yylex()) ;
}

#endif // DEBUG
