// $Id: SetOfASPath.hh 1.6 Fri, 18 Jul 1997 15:53:23 -0700 wlee $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#ifndef SetOfASPath_H
#define SetOfASPath_H

#include "config.hh"
#include "Set.hh"
#include "regexp.hh"

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif // TRUE

class SetOfASPath : public Set {
public:
   friend void rsd_print_as_path(SetOfASPath &re);
   friend void gated_print_as_path(SetOfASPath &re);
   friend ostream& operator<<(ostream& stream, SetOfASPath& nt);
   SetOfASPath() {
      re = new regexp_nf(new regexp_empty_set);
   };
   ~SetOfASPath() {
      delete re;
   }
   SetOfASPath(const SetOfASPath& other) { 
      re = other.re->dup_nf(); 
   }

   virtual int empty() {
      return re->is_empty();
   }

   virtual int universal() {
      return re->is_universal();
   }

   virtual void make_universal() {
      re->become_universal();
   }

   virtual void clear() {
      re->become_empty();
   }

   virtual int add(Pix item) { // add item; return non-zero if successfull
      ASSERT(0);
      return 0;
   }

   void operator =  (regexp *r) { // assignment
      delete re;
      re = new regexp_nf(r->dup());
   }

   virtual void operator ~ () { // complement
      re->do_not();
   }

   void operator |= (SetOfASPath& b) { // union
      re->do_or(*b.re); // makes b empty
   }

   void operator &= (SetOfASPath& b) { // intersection
      re->do_and(*b.re); // makes b empty
   }

   int  operator == (SetOfASPath& b) { // equivalance
      return *re == *b.re;
   }

   void operator =  (SetOfASPath& b) { // assignment
      delete re;
      re = b.re->dup_nf();
   }

   // below is an ugly trick
   virtual void operator |= (Set& b) {
      *this |= (SetOfASPath&) b;
   }
   virtual void operator &= (Set& b) {
      *this &= (SetOfASPath&) b;
   }
   virtual int  operator == (Set& b) {
      return (*this == (SetOfASPath&) b);
   }
   virtual void operator =  (Set& b) {
      *this = (SetOfASPath&) b;
   }

   virtual void do_print (ostream& stream);

CLASS_DEBUG_MEMORY_CC(SetOfASPath);

    operator regexp_nf&() {
      return *re;
   }

private:
   regexp_nf *re;
};


#endif   // SetOfASPath_H
