// $Id: SetOfPrefix.hh 1.7 Fri, 23 Jan 1998 19:06:37 -0800 cengiz $
// 
//  Copyright (c) 1994 by the University of Southern California
//  and/or the International Business Machines Corporation.
//  All rights reserved.
//
//  Permission to use, copy, modify, and distribute this software and
//  its documentation in source and binary forms for lawful
//  non-commercial purposes and without fee is hereby granted, provided
//  that the above copyright notice appear in all copies and that both
//  the copyright notice and this permission notice appear in supporting
//  documentation, and that any documentation, advertising materials,
//  and other materials related to such distribution and use acknowledge
//  that the software was developed by the University of Southern
//  California, Information Sciences Institute and/or the International
//  Business Machines Corporation.  The name of the USC or IBM may not
//  be used to endorse or promote products derived from this software
//  without specific prior written permission.
//
//  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
//  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
//  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
//  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
//  NON-INFRINGEMENT.
//
//  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
//  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
//  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
//  THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//  Questions concerning this software should be directed to 
//  info-ra@isi.edu.
//
//  Author(s): Cengiz Alaettinoglu (cengiz@isi.edu)

#ifndef SetOfPrefix_H
#define SetOfPrefix_H

#pragma interface


#include "config.hh"
#include <iostream.h>
#include <cassert>
#include "RadixSet.hh"
#include "Set.hh"
#include "_SetOfPix.hh"

// the following set class can perform set complement operation 
// without knowing the universal set
class SetOfPrefix : public Set {
friend void rsd_print_net_list(SetOfPrefix &, int, int, int);
friend void gated_print_net_list(SetOfPrefix &, int, int, int, int);
friend int cisco_print_net_list(SetOfPrefix &, int&, int);
friend int cisco_print_packet_filter(SetOfPrefix&);
friend void cisco_default(Pix, Pix);

public:
   SetOfPrefix() : members() {
      _universal = 0;
      not = 0;
   };
   ~SetOfPrefix() {
      members.clear();
   };

   virtual int empty() {
      return (! _universal && members.isEmpty());
   }

   virtual int universal() {
      return (_universal);
   }
   virtual int negated() {
      return (not);
   }

   virtual void make_universal() {
      _universal = 1;
      not = 0;
      members.clear();
   }

   virtual int add(Pix item) {     // add item; return non-zero if successfull
      assert(0);
   }
   virtual void clear() {
      members.clear();
      _universal = 0;
      not = 0;
   }

   virtual void operator ~  (); // complement
   void operator |= (SetOfPrefix& b); // union
   void operator &= (SetOfPrefix& b); // intersection
   int  operator == (SetOfPrefix& b); // equivalance
   void operator =  (SetOfPrefix& b); // assignment
   // below is an ugly trick
   virtual void operator |= (Set& b) {
      *this |= (SetOfPrefix&) b;
   }
   virtual void operator &= (Set& b) {
      *this &= (SetOfPrefix&) b;
   }
   virtual int  operator == (Set& b) {
      return (*this == (SetOfPrefix&) b);
   }
   virtual void operator =  (Set& b) {
      *this = (SetOfPrefix&) b;
   }

   void operator =  (const _SetOfPix& b);
   void insert(const _SetOfPix& b);
   void remove(const _SetOfPix& b);

   friend ostream& operator<<(ostream& stream, SetOfPrefix& nt);
   virtual void do_print (ostream& stream);

   int length();

   int contains(int i);

private:
   RadixSet        members;	// elements if not = false
   unsigned char    _universal;  // true if set equals universal set
   unsigned char    not;         // if true, set = not members

};


#endif // SetOfPrefix_H
