NAME           [[:alpha:]]([[:alnum:]_-]*[[:alnum:]])?

%{
#include "config.h"
#include "util/List.hh"
#include "rpsl/object.hh"

#define LEXER_RETURN return
#define YY_DECL int _objectLog(List<Object> *log)	
#define YY_USER_ACTION scan_position += yyleng;
#define YYLESS(n) {scan_position -= yyleng - n; yyless(n); }

YY_BUFFER_STATE log_buffer = (YY_BUFFER_STATE) NULL;
static int scan_position = 0;
static char *scan_text = NULL;
static bool deleted = false;

%}

%%
\n+          ;  // skip blank lines that do not delimit objects
^(%.*\n)+    ;  // skip comments that do not belong to an object
^(#.*\n)+    ;  // skip comments that do not belong to an object

^{NAME}:(.+\n)+ { // object
   Buffer object(yyleng + 1);
   object.append(yytext, yyleng);
   object.append("\n", 1);
   log->append(new Object(object));
}

%%
extern "C" {
int yywrap () {
   return 1;
}
}

void objectLog(Buffer &buf, List<Object> *log) {
   if (log_buffer)
      yy_delete_buffer(log_buffer);
   log_buffer = yy_scan_bytes(buf.contents, buf.size);
   scan_position = 0;
   scan_text = buf.contents;
   _objectLog(log);
}
