# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 *******************************************************************************
 *
 *	Copyright (c) 1985 Regents of the University of California.
 *	All rights reserved.  The Berkeley software License Agreement
 *	specifies the terms and conditions for redistribution.
 *
 *	@(#)commands.l	3.2	88/06/27	mt Xinu
 *	@(#)commands.l	5.6 (Berkeley) 11/20/87
 *
 *  commands.l
 *
 *  	Andrew Cherenson 	CS298-26  Fall 1985
 *
 *	Lex input file for the nslookup program command interpreter.
 *	When a sequence is recognized, the associated action
 *	routine is called. The action routine may need to
 *	parse the string for additional information.
 *
 *  Recognized commands: (identifiers are shown in uppercase)
 *
 *	server NAME	- set default server to NAME, using default server
 *	lserver NAME	- set default server to NAME, using initial server
 *	finger [NAME]	- finger the optional NAME
 *	root		- set default server to the root
 *	ls NAME		- list the domain NAME
 *	view FILE	- sorts and view the file with more
 *	set OPTION	- set an option
 *	help 		- print help information
 *	? 		- print help information
 *	opt[ions]	- print options, current server, host
 *	NAME		- print info about the host/domain NAME 
 *			  using default server.
 *	NAME1 NAME2	- as above, but use NAME2 as server
 *
 *
 *   yylex Results:
 *	0		upon end-of-file.
 *	1		after each command.
 *  
 *******************************************************************************
 */

#include "res.h"
extern char rootServerName[];

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	{ 
					    /* 
					     * 0 == use current server to find
					     *	    the new one.
					     * 1 == use original server to find
					     *	    the new one.
					     */
					    SetDefaultServer(yytext, 0); 
					    return(1);
					}
break;
case 2:
	{ 
					    SetDefaultServer(yytext, 1); 
					    return(1);
					}
break;
case 3:
			{ 
					    SetDefaultServer(rootServerName, 1);
					    return(1);
					}
break;
case 4:
	{
					    /* 
					     * 2nd arg. 
					     *  0 == output to stdout
					     *  1 == output to file
					     */
					    Finger(yytext, 1); 
					    return(1);
					}
break;
case 5:
	{ 
					    Finger(yytext, 0); 
					    return(1);
					}
break;
case 6:
	{ 
					    ViewList(yytext); 
					    return(1);
					}
break;
case 7:
{ 
					    /* 
					     * 2nd arg. 
					     *  0 == output to stdout
					     *  1 == output to file
					     */
					    ListHosts(yytext, 1);
					    return(1);
					}
break;
case 8:
	{ 
					    ListHosts(yytext, 0);
					    return(1);
					}
break;
case 9:
 	{ 
					    SetOption(yytext); 
					    return(1);
					}
break;
case 10:
			{ 
					    extern void PrintHelp();

					    PrintHelp();
					    return(1);
					}
break;
case 11:
			{ 
					    PrintHelp();
					    return(1);
					}
break;
case 12:
			{ 
					    ShowOptions(TRUE); 
					    return(1);
					}
break;
case 13:
	{
					    /* 
					     * 0 == output to stdout
					     * 1 == output to file
					     */
					    LookupHost(yytext, 1); 
					    return(1);
					}
break;
case 14:
	{
					    LookupHost(yytext, 0); 
					    return(1);
					}
break;
case 15:
	{
					    /* 
					     * 0 == output to stdout
					     * 1 == output to file
					     */
					    LookupHostWithServer(yytext, 1); 
					    return(1);
					}
break;
case 16:
{
					    LookupHostWithServer(yytext, 0); 
					    return(1);
					}
break;
case 17:
			{ 
					    return(1);
					}
break;
case 18:
				{ 
					    printf("Unrecognized command: %s", 
					    		yytext); 
					    return(1);
					}
break;
case 19:
				{ ; }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
int yyvstop[] ={
0,

19,
0,

17,
18,
19,
0,

-14,
0,

-11,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

18,
0,

17,
18,
0,

-14,
0,

14,
18,
0,

11,
18,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-16,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-12,
-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-16,
0,

16,
18,
0,

-13,
0,

-14,
0,

-10,
-14,
0,

-8,
-16,
0,

-14,
0,

-12,
-14,
0,

12,
14,
18,
0,

-14,
0,

-3,
-14,
0,

-14,
0,

-14,
0,

-14,
0,

-13,
0,

13,
18,
0,

-14,
0,

-10,
-14,
0,

10,
14,
18,
0,

-8,
-16,
0,

8,
16,
18,
0,

-14,
0,

-14,
0,

-3,
-14,
0,

3,
14,
18,
0,

-14,
0,

-9,
-16,
0,

-9,
0,

-14,
0,

-15,
0,

-5,
-14,
0,

-14,
0,

-14,
0,

-14,
0,

-9,
-16,
0,

9,
16,
18,
0,

-9,
0,

9,
18,
0,

-6,
-16,
0,

-6,
0,

-15,
0,

15,
18,
0,

-5,
-14,
0,

5,
14,
18,
0,

-8,
0,

-14,
0,

-12,
-14,
0,

-14,
0,

-6,
-16,
0,

6,
16,
18,
0,

-6,
0,

6,
18,
0,

-5,
-16,
0,

-7,
-15,
0,

-8,
0,

8,
18,
0,

-14,
0,

-1,
-16,
0,

-5,
-16,
0,

5,
16,
18,
0,

-4,
-13,
0,

-7,
-15,
0,

7,
15,
18,
0,

-2,
-16,
0,

-1,
-16,
0,

1,
16,
18,
0,

-4,
-13,
0,

4,
13,
18,
0,

-2,
-16,
0,

2,
16,
18,
0,

-4,
-15,
0,

-7,
0,

-4,
-15,
0,

4,
15,
18,
0,

-7,
0,

7,
18,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	0,0,	0,0,	
2,4,	0,0,	4,4,	0,0,	
0,0,	0,0,	0,0,	1,3,	
2,5,	2,6,	4,4,	4,16,	
7,18,	7,19,	5,17,	8,8,	
8,20,	9,4,	0,0,	11,4,	
0,0,	18,18,	18,19,	0,0,	
10,4,	9,18,	9,19,	11,18,	
11,19,	12,4,	0,0,	13,4,	
10,18,	10,19,	23,32,	56,56,	
56,57,	12,18,	12,19,	13,18,	
13,19,	2,7,	21,4,	4,4,	
2,4,	7,7,	4,4,	22,4,	
7,7,	29,41,	21,18,	21,19,	
34,48,	34,49,	18,28,	22,18,	
22,19,	63,76,	9,7,	0,0,	
11,7,	9,7,	2,8,	11,7,	
41,41,	10,7,	121,120,	5,8,	
10,7,	0,0,	12,7,	0,0,	
13,7,	12,7,	18,29,	13,7,	
82,82,	82,83,	0,0,	39,39,	
39,40,	0,0,	29,42,	21,7,	
24,4,	29,42,	21,7,	0,0,	
22,7,	86,86,	86,87,	22,7,	
24,18,	24,19,	98,98,	98,99,	
0,0,	41,42,	0,0,	14,26,	
41,42,	2,9,	29,41,	2,10,	
15,27,	27,38,	5,9,	2,11,	
5,10,	43,58,	2,12,	25,35,	
5,11,	2,13,	2,14,	5,12,	
0,0,	2,15,	5,13,	5,14,	
31,44,	9,21,	5,15,	35,51,	
10,22,	24,7,	23,33,	26,36,	
24,7,	26,37,	28,39,	28,40,	
39,55,	11,23,	30,4,	47,64,	
32,4,	37,53,	37,19,	50,65,	
12,24,	13,25,	30,18,	30,19,	
32,32,	32,19,	52,68,	33,4,	
34,50,	36,4,	58,74,	21,30,	
64,77,	65,78,	22,31,	33,18,	
33,19,	36,18,	36,19,	38,4,	
68,79,	48,48,	48,49,	28,28,	
61,61,	61,62,	28,28,	38,18,	
38,19,	76,76,	37,7,	42,56,	
42,57,	37,7,	77,93,	30,7,	
78,94,	32,45,	30,7,	0,0,	
32,46,	0,0,	32,4,	44,59,	
44,60,	45,61,	45,62,	0,0,	
33,7,	0,0,	36,7,	33,7,	
0,0,	36,7,	48,28,	55,72,	
32,4,	32,29,	0,0,	24,34,	
38,7,	46,4,	76,92,	38,7,	
42,42,	51,66,	51,67,	42,42,	
113,120,	46,4,	46,16,	54,71,	
54,19,	0,0,	48,29,	53,4,	
44,7,	61,75,	45,45,	44,7,	
0,0,	45,45,	0,0,	53,53,	
53,19,	59,59,	59,60,	0,0,	
55,73,	0,0,	32,4,	55,73,	
66,66,	66,67,	69,80,	69,81,	
30,43,	0,0,	51,7,	70,82,	
70,83,	51,7,	46,4,	0,0,	
54,7,	46,4,	71,71,	54,7,	
55,72,	0,0,	72,72,	73,86,	
73,87,	80,80,	80,81,	75,90,	
53,69,	0,0,	59,28,	53,70,	
33,47,	113,121,	74,88,	74,89,	
0,0,	66,28,	36,52,	69,69,	
88,88,	88,89,	69,69,	0,0,	
70,70,	0,0,	90,90,	70,70,	
53,29,	38,54,	59,29,	71,84,	
79,95,	79,19,	71,85,	72,73,	
73,73,	66,29,	72,73,	73,73,	
75,73,	84,96,	84,97,	75,73,	
0,0,	85,98,	85,99,	74,7,	
0,0,	46,63,	74,7,	71,29,	
46,63,	88,100,	91,90,	0,0,	
46,63,	0,0,	80,55,	90,102,	
75,91,	46,63,	90,102,	92,103,	
92,104,	79,7,	0,0,	46,63,	
79,7,	93,105,	93,19,	94,48,	
94,49,	88,101,	84,84,	95,95,	
95,19,	84,84,	85,85,	96,96,	
96,97,	85,85,	100,107,	100,108,	
101,109,	103,103,	103,104,	91,73,	
102,111,	102,112,	91,73,	0,0,	
105,105,	105,19,	106,115,	106,116,	
92,92,	107,107,	107,108,	92,92,	
109,109,	0,0,	93,7,	0,0,	
94,7,	93,7,	117,124,	94,7,	
95,106,	0,0,	110,118,	110,119,	
111,111,	111,112,	0,0,	100,100,	
120,120,	101,110,	100,100,	0,0,	
101,110,	102,102,	114,122,	114,123,	
102,102,	105,114,	0,0,	106,106,	
95,29,	124,124,	106,106,	0,0,	
96,55,	109,110,	115,115,	115,116,	
109,110,	101,109,	103,113,	117,125,	
118,118,	118,119,	117,125,	110,110,	
0,0,	105,29,	110,110,	122,122,	
122,123,	120,126,	107,117,	0,0,	
120,126,	125,127,	125,128,	114,114,	
127,127,	127,128,	114,114,	117,124,	
126,129,	126,130,	124,125,	129,129,	
129,130,	124,125,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	125,125,	115,55,	
0,0,	125,125,	0,0,	0,0,	
0,0,	126,126,	0,0,	0,0,	
126,126,	0,0,	0,0,	0,0,	
122,55,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+1,	0,		0,	
yycrank+-3,	0,		0,	
yycrank+0,	0,		yyvstop+1,
yycrank+-5,	0,		0,	
yycrank+-8,	yysvec+2,	0,	
yycrank+0,	0,		yyvstop+3,
yycrank+-7,	yysvec+4,	yyvstop+7,
yycrank+-10,	yysvec+4,	yyvstop+9,
yycrank+-20,	0,		yyvstop+11,
yycrank+-27,	0,		yyvstop+13,
yycrank+-22,	0,		yyvstop+15,
yycrank+-32,	0,		yyvstop+17,
yycrank+-34,	0,		yyvstop+19,
yycrank+-2,	yysvec+10,	yyvstop+21,
yycrank+-3,	yysvec+9,	yyvstop+23,
yycrank+0,	0,		yyvstop+25,
yycrank+0,	0,		yyvstop+27,
yycrank+-16,	yysvec+4,	yyvstop+30,
yycrank+0,	0,		yyvstop+32,
yycrank+0,	0,		yyvstop+35,
yycrank+-45,	0,		yyvstop+38,
yycrank+-50,	0,		yyvstop+40,
yycrank+-29,	yysvec+10,	yyvstop+42,
yycrank+-87,	0,		yyvstop+44,
yycrank+-4,	yysvec+13,	yyvstop+46,
yycrank+-17,	yysvec+24,	yyvstop+48,
yycrank+-8,	yysvec+10,	yyvstop+50,
yycrank+-125,	yysvec+4,	yyvstop+52,
yycrank+-44,	yysvec+4,	0,	
yycrank+-137,	0,		yyvstop+54,
yycrank+-12,	yysvec+12,	yyvstop+56,
yycrank+-139,	0,		yyvstop+58,
yycrank+-150,	0,		yyvstop+60,
yycrank+-47,	yysvec+9,	yyvstop+62,
yycrank+-11,	yysvec+24,	yyvstop+65,
yycrank+-152,	0,		yyvstop+67,
yycrank+-132,	yysvec+4,	yyvstop+69,
yycrank+-162,	0,		yyvstop+71,
yycrank+-74,	yysvec+4,	yyvstop+73,
yycrank+0,	0,		yyvstop+75,
yycrank+-59,	yysvec+4,	0,	
yycrank+-166,	yysvec+4,	yyvstop+78,
yycrank+-12,	yysvec+10,	yyvstop+80,
yycrank+-178,	yysvec+4,	yyvstop+82,
yycrank+-180,	yysvec+4,	yyvstop+85,
yycrank+-204,	0,		0,	
yycrank+-21,	yysvec+36,	yyvstop+88,
yycrank+-156,	yysvec+4,	yyvstop+90,
yycrank+0,	0,		yyvstop+93,
yycrank+-32,	yysvec+13,	yyvstop+97,
yycrank+-200,	yysvec+4,	yyvstop+99,
yycrank+-49,	yysvec+10,	yyvstop+102,
yycrank+-218,	0,		yyvstop+104,
yycrank+-206,	yysvec+4,	yyvstop+106,
yycrank+-190,	yysvec+4,	0,	
yycrank+-30,	yysvec+4,	yyvstop+108,
yycrank+0,	0,		yyvstop+110,
yycrank+-40,	yysvec+33,	yyvstop+113,
yycrank+-220,	yysvec+4,	yyvstop+115,
yycrank+0,	0,		yyvstop+118,
yycrank+-159,	yysvec+4,	yyvstop+122,
yycrank+0,	0,		yyvstop+125,
yycrank+-52,	yysvec+4,	0,	
yycrank+-55,	yysvec+10,	yyvstop+129,
yycrank+-47,	yysvec+21,	yyvstop+131,
yycrank+-227,	yysvec+4,	yyvstop+133,
yycrank+0,	0,		yyvstop+136,
yycrank+-50,	yysvec+33,	yyvstop+140,
yycrank+-229,	yysvec+4,	yyvstop+142,
yycrank+-234,	yysvec+4,	yyvstop+145,
yycrank+-241,	yysvec+53,	yyvstop+147,
yycrank+-245,	yysvec+4,	0,	
yycrank+-246,	yysvec+4,	yyvstop+149,
yycrank+-257,	yysvec+4,	yyvstop+151,
yycrank+-250,	yysvec+4,	0,	
yycrank+-164,	yysvec+4,	0,	
yycrank+-64,	yysvec+33,	yyvstop+154,
yycrank+-65,	yysvec+11,	yyvstop+156,
yycrank+-275,	yysvec+4,	yyvstop+158,
yycrank+-248,	yysvec+4,	yyvstop+160,
yycrank+0,	0,		yyvstop+163,
yycrank+-71,	yysvec+4,	yyvstop+167,
yycrank+0,	0,		yyvstop+169,
yycrank+-284,	yysvec+4,	yyvstop+172,
yycrank+-288,	yysvec+4,	yyvstop+175,
yycrank+-84,	yysvec+4,	yyvstop+177,
yycrank+0,	0,		yyvstop+179,
yycrank+-263,	yysvec+4,	yyvstop+182,
yycrank+0,	0,		yyvstop+185,
yycrank+-269,	yysvec+4,	0,	
yycrank+-297,	yysvec+4,	0,	
yycrank+-306,	yysvec+4,	yyvstop+189,
yycrank+-312,	yysvec+4,	yyvstop+191,
yycrank+-314,	yysvec+4,	yyvstop+193,
yycrank+-318,	yysvec+4,	yyvstop+196,
yycrank+-322,	yysvec+4,	yyvstop+198,
yycrank+0,	0,		yyvstop+201,
yycrank+-89,	yysvec+4,	yyvstop+205,
yycrank+0,	0,		yyvstop+207,
yycrank+-325,	yysvec+4,	yyvstop+210,
yycrank+-327,	yysvec+4,	0,	
yycrank+-331,	yysvec+4,	yyvstop+213,
yycrank+-328,	yysvec+4,	yyvstop+216,
yycrank+0,	0,		yyvstop+218,
yycrank+-335,	yysvec+4,	yyvstop+221,
yycrank+-337,	yysvec+4,	yyvstop+223,
yycrank+-340,	yysvec+4,	yyvstop+226,
yycrank+0,	0,		yyvstop+229,
yycrank+-343,	yysvec+4,	0,	
yycrank+-353,	yysvec+4,	yyvstop+233,
yycrank+-355,	yysvec+4,	yyvstop+236,
yycrank+0,	0,		yyvstop+239,
yycrank+-203,	yysvec+4,	0,	
yycrank+-365,	yysvec+4,	yyvstop+243,
yycrank+-377,	yysvec+4,	yyvstop+246,
yycrank+0,	0,		yyvstop+249,
yycrank+-349,	yysvec+4,	0,	
yycrank+-383,	yysvec+4,	yyvstop+253,
yycrank+0,	0,		yyvstop+256,
yycrank+-359,	yysvec+4,	0,	
yycrank+-61,	yysvec+4,	0,	
yycrank+-390,	yysvec+4,	yyvstop+260,
yycrank+0,	0,		yyvstop+263,
yycrank+-372,	yysvec+4,	0,	
yycrank+-396,	yysvec+4,	yyvstop+267,
yycrank+-403,	yysvec+4,	yyvstop+270,
yycrank+-399,	yysvec+4,	yyvstop+272,
yycrank+0,	0,		yyvstop+275,
yycrank+-406,	yysvec+4,	yyvstop+279,
yycrank+0,	0,		yyvstop+281,
0,	0,	0};
struct yywork *yytop = yycrank+452;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,'*' ,01  ,01  ,'-' ,'*' ,'-' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,01  ,01  ,01  ,'-' ,01  ,01  ,
01  ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,01  ,01  ,01  ,01  ,'-' ,
01  ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
