// BINDInstallDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BINDInstall.h"
#include "BINDInstallDlg.h"
#include "DirBrowse.h"
#include <winsvc.h>
#include <bind_service.h>
#include <bind_registry.h>
#include <direct.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const char *systemDirFiles[] =
{
	"libbind.dll",
	"bindevt.dll",
	NULL
};

const char *criticalFiles[] = 
{
	"named.exe",
	"named-xfer.exe",
	NULL
};

const char *files[] = 
{
	"nsupdate.exe",
	"BINDCtrl.exe",
	NULL
};

#define VERSION "1.2.0"

/////////////////////////////////////////////////////////////////////////////
// CBINDInstallDlg dialog

CBINDInstallDlg::CBINDInstallDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CBINDInstallDlg::IDD, pParent)
{
	char buf[MAX_PATH];

	//{{AFX_DATA_INIT(CBINDInstallDlg)
	m_targetDir = _T("");
	m_version = _T("");
	m_autoStart = FALSE;
	m_keepFiles = FALSE;
	m_current = _T("");
	m_startOnInstall = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	GetSystemDirectory(buf, MAX_PATH);
	m_defaultDir = buf;
	m_defaultDir += "\\dns";
}

void CBINDInstallDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBINDInstallDlg)
	DDX_Text(pDX, IDC_TARGETDIR, m_targetDir);
	DDX_Text(pDX, IDC_VERSION, m_version);
	DDX_Check(pDX, IDC_AUTO_START, m_autoStart);
	DDX_Check(pDX, IDC_KEEP_FILES, m_keepFiles);
	DDX_Text(pDX, IDC_CURRENT, m_current);
	DDX_Check(pDX, IDC_START, m_startOnInstall);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBINDInstallDlg, CDialog)
	//{{AFX_MSG_MAP(CBINDInstallDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_INSTALL, OnInstall)
	ON_BN_CLICKED(IDC_EXIT, OnExit)
	ON_BN_CLICKED(IDC_UNINSTALL, OnUninstall)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBINDInstallDlg message handlers

BOOL CBINDInstallDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_version.Format("Version %s", VERSION);

	DWORD dwBufLen = MAX_PATH;
	char buf[MAX_PATH];
	HKEY hKey;


	m_startOnInstall = CheckBINDService();

	/* See if we are installed already */
	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, BIND_SUBKEY, 0, KEY_READ, &hKey) == ERROR_SUCCESS)
	{
		memset(buf, 0, MAX_PATH);
		// Get the install directory
		if(RegQueryValueEx(hKey, "InstallDir", NULL, NULL, (LPBYTE)buf, &dwBufLen) == ERROR_SUCCESS)
			if(strcmp(buf, ""))
				m_defaultDir = buf;
		
		RegCloseKey(hKey);
	}
	m_targetDir = m_defaultDir;

	// Set checkbox defaults
	m_autoStart = TRUE;
	m_keepFiles = TRUE;

	UpdateData(FALSE);

	return(TRUE);  // return(TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBINDInstallDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBINDInstallDlg::OnQueryDragIcon()
{
	return((HCURSOR)m_hIcon);
}

void CBINDInstallDlg::OnBrowse() 
{

	CDirBrowse browse;

	if(browse.DoModal() == IDOK)
	{
		//m_targetDir = browse.m_selectedDir;
		UpdateData(FALSE);
	}
}

/*
 * User pressed the exit button
 */
void CBINDInstallDlg::OnExit() 
{
	EndDialog(0);	
}

/*
 * User pressed the uninstall button.  Make it go.
 */
void CBINDInstallDlg::OnUninstall() 
{
	UpdateData();	

	if(MsgBox(IDS_UNINSTALL, MB_YESNO) == IDYES)
	{
		if(CheckBINDService())
			StopBINDService();

		HANDLE hSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
		if(!hSCManager)
		{
			MsgBox(IDS_ERR_OPEN_SCM, GetErrMessage());
			return;
		}
		
		HANDLE hService = OpenService(hSCManager, BIND_SERVICE_NAME, SERVICE_ALL_ACCESS);
		if(!hService && GetLastError() != ERROR_SERVICE_DOES_NOT_EXIST)
		{
			MsgBox(IDS_ERR_OPEN_SERVICE, GetErrMessage());
			return;
		}

		SERVICE_STATUS ss;
		QueryServiceStatus(hService, &ss);
		if(ss.dwCurrentState == SERVICE_RUNNING)
		{
			BOOL rc = ControlService(hService, SERVICE_CONTROL_STOP, &ss);
			if(rc == FALSE || ss.dwCurrentState != SERVICE_STOPPED)
			{
				MsgBox(IDS_ERR_STOP_SERVICE, GetErrMessage());
				return;
			}

		}
		CloseServiceHandle(hService);
		CloseServiceHandle(hSCManager);
		
		// Directories
		m_etcDir = m_targetDir + "\\etc";
		m_binDir = m_targetDir + "\\bin";

		UninstallTags();
		UnregisterMessages(TRUE);
		UnregisterService(TRUE);
		DeleteFiles(TRUE);
		if(m_keepFiles == FALSE)
			RemoveDirs(TRUE);
		else
			GetDlgItem(IDC_CREATE_DIR)->SetWindowText("Not Removed");

		
		// Delete registry keys for named
		RegDeleteKey(HKEY_LOCAL_MACHINE, BIND_SESSION_SUBKEY);
		RegDeleteKey(HKEY_LOCAL_MACHINE, BIND_SUBKEY);
		RegDeleteKey(HKEY_LOCAL_MACHINE, BIND_UNINSTALL_SUBKEY);
	
		SetCurrent(IDS_UNINSTALL_DONE);
		MsgBox(IDS_UNINSTALL_DONE);
	}
}

/*
 * User pressed the install button.  Make it go.
 */
void CBINDInstallDlg::OnInstall() 
{
	BOOL success = FALSE;

	if(CheckBINDService())
		StopBINDService();

	InstallTags();

	UpdateData();

	// Directories
	m_etcDir = m_targetDir + "\\etc";
	m_binDir = m_targetDir + "\\bin";

	if(m_defaultDir != m_targetDir)
	{
		if(GetFileAttributes(m_targetDir) != 0xFFFFFFFF)
		{
			int install = MsgBox(IDS_DIREXIST, MB_YESNO | MB_ICONQUESTION, m_targetDir);
			if(install == IDNO)
				return;
		}
		else
		{
			int createDir = MsgBox(IDS_CREATEDIR, MB_YESNO | MB_ICONQUESTION, m_targetDir);
			if(createDir == IDNO)
				return;
		}
	}

	while(1)
	{
		if(!CreateDirs())
			break;
		if(!CopyFiles())
			break;
		if(!RegisterService())
			break;
		if(!RegisterMessages())
			break;

		success = TRUE;
		break;
	}

	if(success)
	{
		HKEY hKey;

		/* Create a new key for named */
		SetCurrent(IDS_CREATE_KEY);
		if(RegCreateKey(HKEY_LOCAL_MACHINE, BIND_SUBKEY, &hKey) == ERROR_SUCCESS)
		{
			// Get the install directory
			RegSetValueEx(hKey, "InstallDir", 0, REG_SZ, (LPBYTE)(LPCTSTR)m_targetDir, m_targetDir.GetLength());
			RegCloseKey(hKey);
		}

		
		SetCurrent(IDS_ADD_REMOVE);
		if(RegCreateKey(HKEY_LOCAL_MACHINE, BIND_UNINSTALL_SUBKEY, &hKey) == ERROR_SUCCESS)
		{
			char winDir[MAX_PATH];
			CString buf(BIND_DISPLAY_NAME);
			GetWindowsDirectory(winDir, MAX_PATH);

			RegSetValueEx(hKey, "DisplayName", 0, REG_SZ, (LPBYTE)(LPCTSTR)buf, buf.GetLength());

			buf.Format("%s\\BINDInstall.exe", winDir);
			RegSetValueEx(hKey, "UninstallString", 0, REG_SZ, (LPBYTE)(LPCTSTR)buf, buf.GetLength());
			RegCloseKey(hKey);
		}
		if(m_startOnInstall)
			StartBINDService();
	}
	else
	{
		SetCurrent(IDS_CLEANUP);
		FailedInstall();
	}

	SetCurrent(IDS_INSTALL_DONE);
	MsgBox(success == TRUE ? IDS_SUCCESS : IDS_FAIL);

}

/*
 * Methods to do the work
 */
BOOL CBINDInstallDlg::CreateDirs()
{
	
	BOOL rc = FALSE;

	/* s'OK if the directories already exist */
	while(1)
	{
		SetCurrent(IDS_CREATE_DIR, m_targetDir);
		if(!CreateDirectory(m_targetDir, NULL) && GetLastError() != ERROR_ALREADY_EXISTS)
			break;

		SetCurrent(IDS_CREATE_DIR, m_etcDir);
		if(!CreateDirectory(m_etcDir, NULL) && GetLastError() != ERROR_ALREADY_EXISTS)
			break;

		SetCurrent(IDS_CREATE_DIR, m_binDir);
		if(!CreateDirectory(m_binDir, NULL) && GetLastError() != ERROR_ALREADY_EXISTS)
			break;
		
		rc = TRUE;
		break;
	}

	SetItemStatus(IDC_CREATE_DIR, rc);

	return(rc);
}

void CBINDInstallDlg::RemoveDirs(BOOL uninstall)
{
	if(!m_keepFiles)
	{
		SetCurrent(IDS_REMOVE_DIR, m_binDir);
		// Check for existence then remove if present
		if(GetFileAttributes(m_binDir) != 0xFFFFFFFF)
			RemoveDirectory(m_binDir);

		SetCurrent(IDS_REMOVE_DIR, m_etcDir);
		if(GetFileAttributes(m_etcDir) != 0xFFFFFFFF)
			RemoveDirectory(m_etcDir);

		SetCurrent(IDS_REMOVE_DIR, m_targetDir);
		if(GetFileAttributes(m_targetDir) != 0xFFFFFFFF)
			RemoveDirectory(m_targetDir);
	}

	if(uninstall)
		SetItemStatus(IDC_CREATE_DIR, TRUE);
}

BOOL CBINDInstallDlg::CopyFiles()
{
	BOOL rc = TRUE;

	char buf[MAX_PATH];
	CString destFile;
	int i = 0;

	GetSystemDirectory(buf, MAX_PATH);
	
	// Non-critical files
	while(files[i])
	{
		SetCurrent(IDS_COPY_FILE, files[i]);

		destFile = m_binDir + "\\" + files[i];
		if(!CopyFile(files[i], destFile, FALSE))
		{
			if(MsgBox(IDS_ERR_NONCRIT_FILE, MB_YESNO, files[i], GetErrMessage()) == IDNO)
			{
				SetItemStatus(IDC_COPY_FILE, FALSE);
				return(FALSE);
			}
		}
		i++;
	}

	// System directory files
	i = 0;
	while(systemDirFiles[i])
	{
		SetCurrent(IDS_COPY_FILE, systemDirFiles[i]);

		destFile.Format("%s\\%s",buf, systemDirFiles[i]);
		if(!CopyFile(systemDirFiles[i], destFile, FALSE))
		{
			MsgBox(IDS_ERR_CRITICAL_FILE, systemDirFiles[i], GetErrMessage());
			SetItemStatus(IDC_COPY_FILE, FALSE);
			return(FALSE);
		}
		i++;
	}

	// Critical files
	i = 0;
	while(criticalFiles[i])
	{
		SetCurrent(IDS_COPY_FILE, criticalFiles[i]);

		destFile = m_binDir + "\\" + criticalFiles[i];
		if(!CopyFile(criticalFiles[i], destFile, FALSE))
		{
			MsgBox(IDS_ERR_CRITICAL_FILE, criticalFiles[i], GetErrMessage());
			SetItemStatus(IDC_COPY_FILE, FALSE);
			return(FALSE);
		}
		i++;
	}

	// Put the installer in the winnt directory
	SetCurrent(IDS_COPY_FILE, "BINDInstall.exe");
	GetWindowsDirectory(buf, MAX_PATH);
	destFile.Format("%s\\BINDInstall.exe", buf);
	CopyFile("BINDInstall.exe", destFile, FALSE);

	SetItemStatus(IDC_COPY_FILE, rc);
	return(rc);
}

void CBINDInstallDlg::DeleteFiles(BOOL uninstall)
{
	CString destFile;
	int i = 0;

	while(files[i])
	{
		destFile = m_binDir + "\\" + files[i];

		if(uninstall)
			SetCurrent(IDS_DELETE_FILE, files[i]);
		
		DeleteFile(destFile);
		
		i++;
	}

	i = 0;
	while(systemDirFiles[i])
	{
		char buf[MAX_PATH];
		GetSystemDirectory(buf, MAX_PATH);

		destFile.Format("%s\\%s", buf, systemDirFiles[i]);

		if(uninstall)
			SetCurrent(IDS_DELETE_FILE, systemDirFiles[i]);
		
		DeleteFile(destFile);
		
		i++;
	}

	i = 0;
	while(criticalFiles[i])
	{
		destFile = m_binDir + "\\" + criticalFiles[i];

		if(uninstall)
			SetCurrent(IDS_DELETE_FILE, criticalFiles[i]);
		
		DeleteFile(destFile);
		
		i++;
	}

	if(!m_keepFiles)
	{
		WIN32_FIND_DATA findData;
		CString file = m_etcDir + "\\*.*";
		BOOL rc;
		HANDLE hFile;
			
		hFile = FindFirstFile(file, &findData);
		rc = hFile != INVALID_HANDLE_VALUE;
		
		while(rc == TRUE)
		{
			if(strcmp(findData.cFileName, ".") && strcmp(findData.cFileName, ".."))
			{
				file = m_etcDir + "\\" + findData.cFileName;
				SetCurrent(IDS_DELETE_FILE, file);
				DeleteFile(file);
			}
			rc = FindNextFile(hFile, &findData);
		}
		FindClose(hFile);
	}

	if(uninstall)
		SetItemStatus(IDC_COPY_FILE, TRUE);
}	


BOOL CBINDInstallDlg::RegisterService()
{
	BOOL rc = FALSE;
	HANDLE hSCManager;
	HANDLE hService;

	while(1)
	{
		SetCurrent(IDS_OPEN_SCM);
		hSCManager= OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
		if(!hSCManager)
		{
			MsgBox(IDS_ERR_OPEN_SCM, GetErrMessage());
			break;
		}

		DWORD dwStart = SERVICE_DEMAND_START;
		if(m_autoStart)
			dwStart = SERVICE_AUTO_START;

		DWORD dwServiceType = SERVICE_WIN32_OWN_PROCESS;

		CString namedLoc;
		namedLoc.Format("%s\\bin\\named.exe", m_targetDir);

		SetCurrent(IDS_CREATE_SERVICE);
		hService = CreateService(hSCManager, BIND_SERVICE_NAME, BIND_DISPLAY_NAME, SERVICE_ALL_ACCESS, dwServiceType, dwStart,
			SERVICE_ERROR_NORMAL, namedLoc, NULL, NULL, NULL, NULL, NULL);	
		
		if(!hService)
		{
			if(GetLastError() != ERROR_SERVICE_EXISTS)
			{
				MsgBox(IDS_ERR_CREATE_SERVICE, GetErrMessage());
				break;
			}
		}

		rc = TRUE;
		break;
	}

	if(hSCManager)
		CloseServiceHandle(hSCManager);

	if(hService)
		CloseServiceHandle(hService);

	SetItemStatus(IDC_REG_SERVICE, rc);
	
	return(rc);
}

void CBINDInstallDlg::UnregisterService(BOOL uninstall)
{
	BOOL rc = FALSE;
	HANDLE hSCManager;
	HANDLE hService;

	while(1)
	{
		SetCurrent(IDS_OPEN_SCM);
		hSCManager= OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
		if(!hSCManager && uninstall == TRUE)
		{
			MsgBox(IDS_ERR_OPEN_SCM, GetErrMessage());
			break;
		}

		SetCurrent(IDS_OPEN_SERVICE);
		hService = OpenService(hSCManager, BIND_SERVICE_NAME, STANDARD_RIGHTS_REQUIRED);
		if(!hService && uninstall == TRUE)
		{
			if(GetLastError() != ERROR_SERVICE_DOES_NOT_EXIST)
			{
				MsgBox(IDS_ERR_OPEN_SERVICE, GetErrMessage());
				break;
			}
		}
		else
		{
			SetCurrent(IDS_REMOVE_SERVICE);
			if(!DeleteService(hService) && uninstall == TRUE)
			{
				DWORD err = GetLastError();
				if(err != ERROR_SERVICE_MARKED_FOR_DELETE && err != ERROR_SERVICE_DOES_NOT_EXIST)
				{
					MsgBox(IDS_ERR_REMOVE_SERVICE, GetErrMessage());
					break;
				}
			}
		}

		rc = TRUE;
		break;
	}

	if(hSCManager)
		CloseServiceHandle(hSCManager);

	if(hService)
		CloseServiceHandle(hService);

	if(uninstall)
		SetItemStatus(IDC_REG_SERVICE, rc);
}

BOOL CBINDInstallDlg::RegisterMessages()
{
	HKEY hKey;
	DWORD dwData;
	BOOL rc = FALSE;
	char pszMsgDLL[MAX_PATH], buf[MAX_PATH];

	GetSystemDirectory(buf, MAX_PATH);
	sprintf(pszMsgDLL, "%s\\%s", buf, "bindevt.dll");

	while(1)
	{
		SetCurrent(IDS_REGISTER_MESSAGES);
		/* Create a new key for named */
		if(RegCreateKey(HKEY_LOCAL_MACHINE, BIND_MESSAGE_SUBKEY, &hKey) != ERROR_SUCCESS)
			break;
		
		/* Add the Event-ID message-file name to the subkey. */
		if(RegSetValueEx(hKey, "EventMessageFile", 0, REG_EXPAND_SZ, (LPBYTE)pszMsgDLL, strlen(pszMsgDLL) + 1) != ERROR_SUCCESS)
			break;

		/* Set the supported types flags and addit to the subkey. */
		dwData = EVENTLOG_ERROR_TYPE | EVENTLOG_WARNING_TYPE | EVENTLOG_INFORMATION_TYPE;
		if(RegSetValueEx(hKey, "TypesSupported", 0, REG_DWORD, (LPBYTE)&dwData, sizeof(DWORD)) != ERROR_SUCCESS)
			break;

		RegCloseKey(hKey);
		
		/* Create a new key for named-xfer */
		if(RegCreateKey(HKEY_LOCAL_MACHINE, XFER_MESSAGE_SUBKEY, &hKey) != ERROR_SUCCESS)
			break;

		/* Add the Event-ID message-file name to the subkey. */
		if(RegSetValueEx(hKey, "EventMessageFile", 0, REG_EXPAND_SZ, (LPBYTE)pszMsgDLL, strlen(pszMsgDLL) + 1) != ERROR_SUCCESS)
			break;

		/* Set the supported types flags and addit to the subkey. */
		dwData = EVENTLOG_ERROR_TYPE | EVENTLOG_WARNING_TYPE | EVENTLOG_INFORMATION_TYPE;
		if(RegSetValueEx(hKey, "TypesSupported", 0, REG_DWORD, (LPBYTE)&dwData, sizeof(DWORD)) != ERROR_SUCCESS)
			break;

		rc = TRUE;
		break;
	}

	if(hKey) 
		RegCloseKey(hKey);
		
	SetItemStatus(IDC_REG_MESSAGE, rc);

	return(rc);
}

void CBINDInstallDlg::UnregisterMessages(BOOL uninstall)
{
	BOOL rc = FALSE;
	HKEY hKey = NULL;

	while(1)
	{
		SetCurrent(IDS_UNREGISTER_MESSAGES);
		/* Open key for Application Event Log */
		if(RegOpenKey(HKEY_LOCAL_MACHINE, EVENTLOG_APP_SUBKEY, &hKey) != ERROR_SUCCESS)
			break;

		/* Remove named from the list of messages sources */
		if(RegDeleteKey(hKey, BIND_MESSAGE_NAME) != ERROR_SUCCESS)
			break;

		/* Remove named-xfer from the list of messages sources */
		if(RegDeleteKey(hKey, XFER_MESSAGE_NAME) != ERROR_SUCCESS)
			break;
		
		rc = TRUE;
		break;
	}

	if(hKey)
		RegCloseKey(hKey);

	if(uninstall)
		SetItemStatus(IDC_REG_MESSAGE, rc);
}

/*
 * Install failed - clean up quietly
 */
void CBINDInstallDlg::FailedInstall()
{
	UnregisterMessages(FALSE);
	UnregisterService(FALSE);
	DeleteFiles(FALSE);
	RemoveDirs(FALSE);
}

/*
 * Set the checklist tags for install
 */
void CBINDInstallDlg::InstallTags()
{
	CString tag;
	
	tag.LoadString(IDS_INSTALL_FILE);
	GetDlgItem(IDC_COPY_TAG)->SetWindowText(tag);
	GetDlgItem(IDC_COPY_FILE)->SetWindowText("");

	tag.LoadString(IDS_INSTALL_DIR);
	GetDlgItem(IDC_DIR_TAG)->SetWindowText(tag);
	GetDlgItem(IDC_CREATE_DIR)->SetWindowText("");
	GetDlgItem(IDC_REG_SERVICE)->SetWindowText("");

	tag.LoadString(IDS_INSTALL_SERVICE);
	GetDlgItem(IDC_SERVICE_TAG)->SetWindowText(tag);
	
	tag.LoadString(IDS_INSTALL_MESSAGE);
	GetDlgItem(IDC_MESSAGE_TAG)->SetWindowText(tag);
	GetDlgItem(IDC_REG_MESSAGE)->SetWindowText("");
}

/*
 * Set the checklist tags for uninstall
 */
void CBINDInstallDlg::UninstallTags()
{
	CString tag;
	
	tag.LoadString(IDS_UNINSTALL_FILES);
	GetDlgItem(IDC_COPY_TAG)->SetWindowText(tag);
	GetDlgItem(IDC_COPY_FILE)->SetWindowText("");

	tag.LoadString(IDS_UNINSTALL_DIR);
	GetDlgItem(IDC_DIR_TAG)->SetWindowText(tag);
	GetDlgItem(IDC_CREATE_DIR)->SetWindowText("");

	tag.LoadString(IDS_UNINSTALL_SERVICE);
	GetDlgItem(IDC_SERVICE_TAG)->SetWindowText(tag);
	GetDlgItem(IDC_REG_SERVICE)->SetWindowText("");
	
	tag.LoadString(IDS_UNINSTALL_MESSAGE);
	GetDlgItem(IDC_MESSAGE_TAG)->SetWindowText(tag);
	GetDlgItem(IDC_REG_MESSAGE)->SetWindowText("");
}

void CBINDInstallDlg::SetItemStatus(UINT nID, BOOL bSuccess)
{
	GetDlgItem(nID)->SetWindowText(bSuccess == TRUE ? "Done" : "Failed");
}


/*
 * Set the text in the current operation field - use a string table string
 */
void CBINDInstallDlg::SetCurrent(int id, ...)
{
	CString format;
	va_list va;
	char buf[128];

	format.LoadString(id);
	memset(buf, 0, 128);

	va_start(va, id);
	vsprintf(buf, format, va);
	va_end(va);
	
	m_current.Format("%s", buf);
	UpdateData(FALSE);
}

/*
 * Stop the BIND service
 */
void CBINDInstallDlg::StopBINDService()
{
	SERVICE_STATUS svcStatus;
	
	SetCurrent(IDS_STOP_SERVICE);

	HANDLE hSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if(!hSCManager)
	{
		MsgBox(IDS_ERR_OPEN_SCM, GetErrMessage());
	}
	
	HANDLE hBINDSvc = OpenService(hSCManager, BIND_SERVICE_NAME, SERVICE_ALL_ACCESS);
	if(!hBINDSvc)
	{
		MsgBox(IDS_ERR_OPEN_SERVICE, GetErrMessage());
	}
	
	BOOL rc = ControlService(hBINDSvc, SERVICE_CONTROL_STOP, &svcStatus);
}

/*
 * Start the BIND service
 */
void CBINDInstallDlg::StartBINDService()
{
	SetCurrent(IDS_START_SERVICE);

	HANDLE hSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if(!hSCManager)
	{
		MsgBox(IDS_ERR_OPEN_SCM, GetErrMessage());
	}
	
	HANDLE hBINDSvc = OpenService(hSCManager, BIND_SERVICE_NAME, SERVICE_ALL_ACCESS);
	if(!hBINDSvc)
	{
		MsgBox(IDS_ERR_OPEN_SERVICE, GetErrMessage());
	}
	BOOL rc = StartService(hBINDSvc, 0, NULL);
}

/*
 * Check to see if the BIND service is running or not
 */
BOOL CBINDInstallDlg::CheckBINDService()
{
	SERVICE_STATUS svcStatus;

	HANDLE hSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_ALL_ACCESS);
	if(hSCManager)
	{
		HANDLE hBINDSvc = OpenService(hSCManager, BIND_SERVICE_NAME, SERVICE_ALL_ACCESS);
		if(hBINDSvc)
		{
			BOOL rc = ControlService(hBINDSvc, SERVICE_CONTROL_INTERROGATE, &svcStatus);
			if(!rc)
				DWORD err = GetLastError();

			return(svcStatus.dwCurrentState == SERVICE_RUNNING);
		}
	}
	return(FALSE);
}

/*
 * Display message boxes with variable args, using string table strings for the format specifiers 
 */
int CBINDInstallDlg::MsgBox(int id, ...)
{
	CString format;
	va_list va;
	char buf[BUFSIZ];

	format.LoadString(id);
	memset(buf, 0, BUFSIZ);

	va_start(va, id);
	vsprintf(buf, format, va);
	va_end(va);

	return(MessageBox(buf));
}

int CBINDInstallDlg::MsgBox(int id, UINT type, ...)
{
	CString format;
	va_list va;
	char buf[BUFSIZ];

	format.LoadString(id);
	memset(buf, 0, BUFSIZ);

	va_start(va, type);
	vsprintf(buf, format, va);
	va_end(va);

	return(MessageBox(buf, NULL, type));
}

/*
 * Call GetLastError(), retrieve the message associated with the error
 */
CString CBINDInstallDlg::GetErrMessage()
{	
	LPVOID msgBuf;
	static char buf[BUFSIZ];
	
	DWORD len = FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
				  NULL, GetLastError(), MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), (LPTSTR) &msgBuf, 0, NULL );


	strcpy(buf, (LPTSTR)msgBuf);
	LocalFree(msgBuf);
	/* Strip off the period and the \n */
	buf[len - 3] = 0;
	return(buf);
}
