#!/bin/sh
#
# Copyright (C) 2004, 2007, 2009-2012, 2014, 2016  Internet Systems Consortium, Inc. ("ISC")
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

SYSTEMTESTTOP=../..
. $SYSTEMTESTTOP/conf.sh

(cd ../ns6 && $SHELL -e ./sign.sh)

echo "I:dlv/ns3/sign.sh"

dlvzone=dlv.utld.
dlvsets=
dssets=

zone=child1.utld.
infile=child.db.in
zonefile=child1.utld.db
outfile=child1.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null` 
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child3.utld.
infile=child.db.in
zonefile=child3.utld.db
outfile=child3.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child4.utld.
infile=child.db.in
zonefile=child4.utld.db
outfile=child4.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child5.utld.
infile=child.db.in
zonefile=child5.utld.db
outfile=child5.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child7.utld.
infile=child.db.in
zonefile=child7.utld.db
outfile=child7.signed

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child8.utld.
infile=child.db.in
zonefile=child8.utld.db
outfile=child8.signed

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child9.utld.
infile=child.db.in
zonefile=child9.utld.db
outfile=child9.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"

zone=child10.utld.
infile=child.db.in
zonefile=child10.utld.db
outfile=child10.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"

zone=child1.druz.
infile=child.db.in
zonefile=child1.druz.db
outfile=child1.druz.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"
dssets="$dssets dsset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null` 
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child3.druz.
infile=child.db.in
zonefile=child3.druz.db
outfile=child3.druz.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"
dssets="$dssets dsset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child4.druz.
infile=child.db.in
zonefile=child4.druz.db
outfile=child4.druz.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"
dssets="$dssets dsset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child5.druz.
infile=child.db.in
zonefile=child5.druz.db
outfile=child5.druz.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"
dssets="$dssets dsset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child7.druz.
infile=child.db.in
zonefile=child7.druz.db
outfile=child7.druz.signed
dssets="$dssets dsset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

dsfilename=../ns6/dsset-grand.`echo $zone |sed -e "s/\.$//g"`$TP
cat $infile $keyname1.key $keyname2.key $dsfilename >$zonefile

$SIGNER -r $RANDFILE -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child8.druz.
infile=child.db.in
zonefile=child8.druz.db
outfile=child8.druz.signed

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=child9.druz.
infile=child.db.in
zonefile=child9.druz.db
outfile=child9.druz.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"

zone=child10.druz.
infile=child.db.in
zonefile=child10.druz.db
outfile=child10.druz.signed
dlvsets="$dlvsets dlvset-`echo $zone |sed -e "s/.$//g"`$TP"
dssets="$dssets dsset-`echo $zone |sed -e "s/.$//g"`$TP"

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -l $dlvzone -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


zone=dlv.utld.
infile=dlv.db.in
zonefile=dlv.utld.db
outfile=dlv.signed

keyname1=`$KEYGEN -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`
keyname2=`$KEYGEN -f KSK -r $RANDFILE -a DSA -b 768 -n zone $zone 2> /dev/null`

cat $infile $dlvsets $keyname1.key $keyname2.key >$zonefile

$SIGNER -r $RANDFILE -o $zone -f $outfile $zonefile > /dev/null 2> signer.err || cat signer.err
echo "I: signed $zone"


grep -v '^;' $keyname2.key | $PERL -n -e '
local ($dn, $class, $type, $flags, $proto, $alg, @rest) = split;
local $key = join("", @rest);
print <<EOF
trusted-keys {
    "$dn" $flags $proto $alg "$key";
};
EOF
' > trusted-dlv.conf
cp trusted-dlv.conf ../ns5

cp $dssets ../ns2
