#! /bin/sh
#
# This script makes preload-files for the updgen program. These preload files
# are slightly digested extracts of the COM zone. We do this processing now
# so that we don't have to do it every time we run updgen
# 
# We assume that a copy of the COM zone is in ./com.zone
#

test -d TMPdir && rm -rf TMPdir
mkdir TMPdir


fgrep " NS " com.zone | \
	cut -f 1-1 -d " " | \
	sort -T TMPdir -u > NS.preload



fgrep " A " com.zone | \
	cut -f 1-1 -d " " | \
	sort -T TMPdir -u > A.preload
