/*  $Id: trash.c,v 1.10 2000/04/08 04:29:14 rra Exp $
**
**  Trashing articles method
*/
#include "config.h"
#include "clibrary.h"
#include "libinn.h"
#include "methods.h"

BOOL trash_init(BOOL *selfexpire) {
    *selfexpire = TRUE;
    return TRUE;
}

TOKEN trash_store(const ARTHANDLE article, const STORAGECLASS class) {
    TOKEN               token;

    if (article.token == (TOKEN *)NULL)
	memset(&token, '\0', sizeof(token));
    else {
	memcpy(&token, article.token, sizeof(token));
	memset(&token.token, '\0', STORAGE_TOKEN_LENGTH);
    }
    token.type = TOKEN_TRASH;
    token.class = class;
    return token;
}

ARTHANDLE *trash_retrieve(const TOKEN token, const RETRTYPE amount) {
    if (token.type != TOKEN_TRASH) {
	SMseterror(SMERR_INTERNAL, NULL);
	return (ARTHANDLE *)NULL;
    }
    SMseterror(SMERR_NOENT, NULL);
    return (ARTHANDLE *)NULL;
}

void trash_freearticle(ARTHANDLE *article) {
}

BOOL trash_cancel(TOKEN token) {
    SMseterror(SMERR_NOENT, NULL);
    return FALSE;
}

BOOL trash_ctl(PROBETYPE type, TOKEN *token, void *value) {
    switch (type) {
    case SMARTNGNUM:
    default:
	return FALSE;
    }
}

BOOL trash_flushcacheddata(FLUSHTYPE type) {
    return TRUE;
}

ARTHANDLE *trash_next(const ARTHANDLE *article, const RETRTYPE amount) {
    return (ARTHANDLE *)NULL;
}

void trash_shutdown(void) {
}
