import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';

import { AuthGuard } from './auth.guard';
import { DashboardComponent } from './dashboard/dashboard.component';
import { LoginScreenComponent } from './login-screen/login-screen.component';
import { SwaggerUiComponent } from './swagger-ui/swagger-ui.component';
import { MachinesPageComponent } from './machines-page/machines-page.component';


const routes: Routes = [
    {
        path: '',
        // component: DashboardComponent,
        pathMatch: 'full',
        // canActivate: [AuthGuard],
        redirectTo: 'machines/',
    },
    {
        path: 'login',
        component: LoginScreenComponent,
    },
    {
        path: 'machines',
        redirectTo: 'machines/',
        pathMatch: 'full'
    },
    {
        path: 'machines/:id',
        component: MachinesPageComponent,
        canActivate: [AuthGuard],
    },
    {
        path: 'swagger-ui',
        component: SwaggerUiComponent,
        canActivate: [AuthGuard],
    },


    // otherwise redirect to home
    { path: '**', redirectTo: '' }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
