#!/usr/bin/awk -f
#
# $Id: top2hosts.awk,v 1.1 2002/10/25 02:18:37 jabley Exp $
#
# Parse a top file and output a hosts(5) file.

BEGIN {
  FS = ":";
}

/^node:/ {
  name[$2] = $6;
}

function add_if(ifname, ifaddr, rtname) {
  if (already[ifaddr] == 0) {
    already[ifaddr] = 1;

# the following is specific to a particular naming plan based on
# interface names, and will need to be changed according to local
# requirements.
#
# This (example) naming plan processes interface names like this:
#
#  interface               router       DNS name
#
#  GigabitEthernet4/1.357  orex8.pf     357.ge4-1.orex8.pf.example.isc.org
#  ge-4/1/0 unit 220       orex9.pf     220.ge-4-1-0.orex9.pf.example.isc.org
#  Loopback0               orex4.pf     loopback0.orex4.pf.example.isc.org

    revname = tolower(ifname);

    gsub(/\//, "-", revname);           # replace "/" characters with hyphens
    gsub(/:/, "-", revname);            # replace ":"s with hyphens
    gsub(/ethernet/, "e", revname);     # replace "ethernet" with "e"
    gsub(/fast/, "f", revname);         # replace "fast" with "f"
    gsub(/gigabit/, "g", revname);      # replace "gigabit" with "g"

    # Reverse the order, so (for example) ATM4/1.357 becomes 357.atm4-1

    n = split(revname, part, /\./);
    dnsname = "";
    while (--n)
      dnsname = part[n] ".";

    # append the router name
    dnsname = dnsname rtname;

    # append a domain name, since in this example the names in the top
    # file don't contain them

    dnsname = dnsname ".example.isc.org";

# local name policy application bits finished

    printf "%s\t%s\n", ifaddr, dnsname;
  }
}

/^edge:/ {
  add_if($3, $4, name[$5]);
  add_if($6, $7, name[$8]);
}

