/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rcbcl.c,v 1.17 2005/05/31 21:00:28 ca Exp $")
#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"
#include "sm/memops.h"
#include "sm/io.h"
#include "sm/ctype.h"
#include "sm/fcntl.h"
#include "sm/rcb.h"
#include "sm/unixsock.h"
#include "sm/check.h"
#include "t-rcb.h"

#include <stdio.h>

extern char *optarg;
extern int optind;
extern int optopt;
extern int opterr;

int Verbose;

void
usage(const char *prg)
{
	fprintf(stderr, "usage: %s [options] socket\n", prg);
	exit(0);
}

/*
**  CLIENT -- send rcb
**
**	Parameters:
**		sockname -- name of socket
**
**	Returns:
**		none
*/

void
client(char *sockname)
{
	int fd;
	int res, c;
	sm_rcb_P rcb;
	sm_ret_T ret;

	if (Verbose > 1)
		fprintf(stderr, "clt: connect\n");
	rcb = NULL;
	(void) unix_client_connect(sockname, &fd);
	if (Verbose > 1)
		fprintf(stderr, "clt: connected=%d, errno=%d\n", fd, errno);
	SM_TEST(fd >= 0);
	if (fd < 0)
		return;

	rcb = sm_rcb_new(NULL, SM_RCBSIZE, SM_MAXRCBSIZE);
	SM_TEST(rcb != NULL);
	if (rcb == NULL)
		goto done;

	ret = sm_rcb_open_enc(rcb, -1);
	SM_TEST(sm_is_success(ret));

	/* just a place holder for the size */
	ret = sm_rcb_putuint32(rcb, 0);
	SM_TEST(sm_is_success(ret));

	while ((c = getchar()) != EOF)
	{
		if (c == 'I')
		{
			ret = addint(rcb);
			SM_TEST(sm_is_success(ret));
		}
		else if (c == 'S')
		{
			ret = addstr(rcb);
			SM_TEST(sm_is_success(ret));
		}
		else
		{
			ret = sm_rcb_close_enc(rcb);
			SM_TEST(ret == SM_SUCCESS);
			if (sm_is_err(ret))
				break;

			if (Verbose > 1)
				fprintf(stderr, "write: %d\n",
					(int) sm_rcb_getlen(rcb));

			ret = sm_rcb_open_snd(rcb);
			SM_TEST(sm_is_success(ret));
			do
			{
				res = sm_rcb_snd(fd, rcb);
				SM_TEST(res >= 0);
			} while (res != 0);
			if (res != 0)
			{
				fprintf(stderr,
					"clt: write_fd failed=%d, len=%d, errno=%d\n",
					res, (int) sm_rcb_getlen(rcb), errno);
				ret = sm_err_perm(EIO);
			}
			else
			{
				ret = sm_rcb_close_snd(rcb);
				SM_TEST(sm_is_success(ret));
				ret = sm_rcb_open_enc(rcb, -1);
				SM_TEST(sm_is_success(ret));
				ret = sm_rcb_putuint32(rcb, 0);
				SM_TEST(sm_is_success(ret));
			}
		}
		if (sm_is_err(ret))
			break;
	}

  done:
	if (rcb != NULL)
		sm_rcb_free(rcb);
	close(fd);
}

int
main(int argc, char *argv[])
{
	int c;
	char *sockname, *prg;

	opterr = 0;
	Verbose = 0;
	sockname = NULL;
	prg = argv[0];
	while ((c = getopt(argc, argv, "V")) != -1)
	{
		switch (c)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			usage(prg);
		}
	}
	sm_test_begin(argc, argv, "unix socket rcb client");
	argc -= optind;
	argv += optind;
	if (argc <= 0)
		usage(prg);
	sockname = argv[0];
	client(sockname);
	return sm_test_end();
}
