/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-strc.c,v 1.12 2005/04/14 17:14:02 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	sm_str_P s, s2, s3, s4, s5;
	size_t len;
	sm_ret_T r;
	char *src1 = "magic buf";
	char *src2 = "mAgIc strbUf";
	char *g;
	bool tst;
	char buf[1024];

	for (len = 0; len < sizeof(buf); len++)
		buf[len] = '\0';
	s = sm_str_scpy(a, src1, SMAXLEN);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(src1));
	SM_TEST(strcmp((char *) sm_str_getdata(s), src1) == 0);
	sm_str_free(s);

	len = strlen(src1) + strlen(src2);
	s = sm_str_scpy(a, src1, len);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(src1));
	s2 = sm_str_scpy(a, src2, len);
	SM_TEST(s2 != NULL);
	SM_TEST(sm_str_getlen(s2) == strlen(src2));
	r = sm_str_cat(s, s2);
	SM_TEST(r == SM_SUCCESS);
	SM_TEST(sm_str_cat(s, s2) != SM_SUCCESS);
	sm_str_free(s);
	sm_str_free(s2);

	len = strlen(src1) + strlen(src2);
	s = sm_str_scpy(a, src1, len * 2);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(src1));
	s2 = sm_str_scpy(a, src2, len);
	SM_TEST(s2 != NULL);
	SM_TEST(sm_str_getlen(s2) == strlen(src2));
	r = sm_str_cat(s, s2);
	SM_TEST(r == SM_SUCCESS);
	g = (char *) sm_str_getdata(s);
	SM_TEST(g != NULL);
	tst = sizeof(buf) > strlen(src1) + strlen(src2) + 2;
	SM_TEST(tst);

	/* we can't rely on existence of strlcpy() here */
	if (tst)
	{
		SM_ASSERT(strlen(src1) < sizeof(buf));
#if HAVE_STRLCPY
		strlcpy(buf, src1, sizeof(buf));
#else
		strcpy(buf, src1);
#endif
		SM_ASSERT(strlen(src2) < sizeof(buf));
#if HAVE_STRLCAT
		strlcat(buf, src2, sizeof(buf));
#else
		strcat(buf, src2);
#endif
	}
	SM_TEST(strcmp(g, buf) == 0);
	sm_str_free(s);

	len = strlen(src1) + 2;
	s = sm_str_scpy(a, src1, len);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(src1));
	r = sm_str_cat(s, s2);
	SM_TEST(r != SM_SUCCESS);

	sm_str_free(s2);
	sm_str_free(s);

	s = sm_str_scpy(a, src1, SMAXLEN);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(src1));
	s2 = sm_str_dup(a, s);
	SM_TEST(s2 != NULL);
	SM_TEST(sm_str_getlen(s2) == strlen(src1));
	s3 = sm_str_dup(a, s);
	SM_TEST(s3 != NULL);
	SM_TEST(sm_str_getlen(s3) == strlen(src1));
	s4 = sm_str_dup(a, s);
	SM_TEST(s4 != NULL);
	SM_TEST(sm_str_getlen(s4) == strlen(src1));
	s5 = sm_str_dup(a, s);
	SM_TEST(s5 != NULL);
	SM_TEST(sm_str_getlen(s5) == strlen(src1));
	r = sm_str_catv(s, 4, s2, s3, s4, s5);
	SM_TEST(r == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == strlen(src1) * 5);

	sm_str_clr(s);
	r = sm_str_scatv(s, 3, "one", " 2 ", " three");
	SM_TEST(r == SM_SUCCESS);
	SM_TEST(sm_str_getlen(s) == strlen("one 2  three"));
	SM_TEST(strncmp((char *) sm_str_getdata(s),
			"one 2  three", sm_str_getlen(s)) == 0);

	sm_str_free(s5);
	sm_str_free(s4);
	sm_str_free(s3);
	sm_str_free(s2);
	sm_str_free(s);

	len = strlen(src1) + strlen(src2);
	s = sm_str_scpy(a, src1, len - 1);
	SM_TEST(s != NULL);
	SM_TEST(sm_str_getlen(s) == strlen(src1));
	s2 = sm_str_scpy(a, src2, len);
	SM_TEST(s2 != NULL);
	SM_TEST(sm_str_getlen(s2) == strlen(src2));
	r = sm_str_cat(s, s2);
	SM_TEST(r != SM_SUCCESS);
	sm_str_free(s2);
	sm_str_free(s);

}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test bufc");
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);
	test_harness(NULL);
	return sm_test_end();
}
