#!/bin/sh
# $Id: t-t2821-3.sh,v 1.7 2005/04/10 23:44:41 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#

test -s stop && exit 1

ERRORS=0
IN=t2821_parse.in
OUT=t2821_parse.out
ERR=t2821_parse.err
ERRORS=0
./t-t2821-0 $@ > ${OUT} 2> ${ERR} <<EOF
<a@[1.2.3.4]>
<a@[1.2.3.4.5]>
<a@[1.2.3.4.]>
<a@[1..2.3.4]>
<a@[1.2.3.255]>
<a@[1.2.3.256]>
<a@[256.2.3.255]>
<a@[1.2.3.4>
<a@[1.2.3.A]>
<a@[1.2.3.\1]>
EOF

cat > ${IN} <<EOF
>>><a@[1.2.3.4]><<<
OK	>>><a@[1.2.3.4]><<<
<a@[1.2.3.4]>
>>><a@[1.2.3.4.5]><<<
FAILED=9c040016	>>><a@[1.2.3.4.5]><<<
>>><a@[1.2.3.4.]><<<
FAILED=9c040016	>>><a@[1.2.3.4.]><<<
>>><a@[1..2.3.4]><<<
FAILED=9c040016	>>><a@[1..2.3.4]><<<
>>><a@[1.2.3.255]><<<
OK	>>><a@[1.2.3.255]><<<
<a@[1.2.3.255]>
>>><a@[1.2.3.256]><<<
FAILED=9c040016	>>><a@[1.2.3.256]><<<
>>><a@[256.2.3.255]><<<
FAILED=9c040016	>>><a@[256.2.3.255]><<<
>>><a@[1.2.3.4><<<
FAILED=9b040214	>>><a@[1.2.3.4><<<
>>><a@[1.2.3.A]><<<
FAILED=9c040016	>>><a@[1.2.3.A]><<<
>>><a@[1.2.3.\1]><<<
FAILED=9c040016	>>><a@[1.2.3.\1]><<<
EOF
diff ${OUT} ${IN}

if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1`
fi


./t-t2821-1 -i $@ > ${OUT} 2> ${ERR} <<EOF
<a@[1.2.3.4]>
<a@[1.2.3.255]>
<a@[127.0.0.1]>
<a@[127.0.0.0]>
<a@[0x7f000001]>
EOF

cat > ${IN} <<EOF
>>><a@[1.2.3.4]><<<
OK	>>><a@[1.2.3.4]><<<
<a@[1.2.3.4]>
domain=[1.2.3.4]
ipv4=1020304
>>><a@[1.2.3.255]><<<
OK	>>><a@[1.2.3.255]><<<
<a@[1.2.3.255]>
domain=[1.2.3.255]
ipv4=10203ff
>>><a@[127.0.0.1]><<<
OK	>>><a@[127.0.0.1]><<<
<a@[127.0.0.1]>
domain=[127.0.0.1]
ipv4=7f000001
>>><a@[127.0.0.0]><<<
OK	>>><a@[127.0.0.0]><<<
<a@[127.0.0.0]>
domain=[127.0.0.0]
ipv4=7f000000
>>><a@[0x7f000001]><<<
OK	>>><a@[0x7f000001]><<<
<a@[0x7f000001]>
domain=[0x7f000001]
ipv4=7f000001
EOF
diff ${OUT} ${IN}

if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1`
fi

# local part + detail: keep quotes if required by RFC 2821
./t-t2821-1 -d+ -D $@ > ${OUT} 2> ${ERR} <<EOF
<l@b.c>
<l+@b.c>
<+x@b.c>
<l+x@b.c>
<+x@b.c>
<"l+x"@b.c>
<"l+x@z"@b.c>
<l+x+y@b.c>
<"l+x z"@b.c>
EOF

cat > ${IN} <<EOF
>>><l@b.c><<<
OK	>>><l@b.c><<<
<l@b.c>
local=l, detail=
>>><l+@b.c><<<
OK	>>><l+@b.c><<<
<l+@b.c>
local=l, detail=
>>><+x@b.c><<<
OK	>>><+x@b.c><<<
<+x@b.c>
local=, detail=x
>>><l+x@b.c><<<
OK	>>><l+x@b.c><<<
<l+x@b.c>
local=l, detail=x
>>><+x@b.c><<<
OK	>>><+x@b.c><<<
<+x@b.c>
local=, detail=x
>>><"l+x"@b.c><<<
OK	>>><"l+x"@b.c><<<
<l+x@b.c>
local=l, detail=x
>>><"l+x@z"@b.c><<<
OK	>>><"l+x@z"@b.c><<<
<"l+x@z"@b.c>
local=l+x@z, detail=
>>><l+x+y@b.c><<<
OK	>>><l+x+y@b.c><<<
<l+x+y@b.c>
local=l, detail=x+y
>>><"l+x z"@b.c><<<
OK	>>><"l+x z"@b.c><<<
<"l+x z"@b.c>
local=l+x z, detail=
EOF
diff ${OUT} ${IN}

if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1`
fi

# local part + detail: remove quotes
./t-t2821-1 -q -d+ -D $@ > ${OUT} 2> ${ERR} <<EOF
<"l"@b.c>
<l@b.c>
<l+@b.c>
<l+x@b.c>
<+x@b.c>
<"l+x"@b.c>
<"l+x@z"@b.c>
<l+x+y@b.c>
<"l+x z"@b.c>
EOF

cat > ${IN} <<EOF
>>><"l"@b.c><<<
OK	>>><"l"@b.c><<<
<l@b.c>
local=l, detail=
>>><l@b.c><<<
OK	>>><l@b.c><<<
<l@b.c>
local=l, detail=
>>><l+@b.c><<<
OK	>>><l+@b.c><<<
<l+@b.c>
local=l, detail=
>>><l+x@b.c><<<
OK	>>><l+x@b.c><<<
<l+x@b.c>
local=l, detail=x
>>><+x@b.c><<<
OK	>>><+x@b.c><<<
<+x@b.c>
local=, detail=x
>>><"l+x"@b.c><<<
OK	>>><"l+x"@b.c><<<
<l+x@b.c>
local=l, detail=x
>>><"l+x@z"@b.c><<<
OK	>>><"l+x@z"@b.c><<<
<"l+x@z"@b.c>
local=l, detail=x@z
>>><l+x+y@b.c><<<
OK	>>><l+x+y@b.c><<<
<l+x+y@b.c>
local=l, detail=x+y
>>><"l+x z"@b.c><<<
OK	>>><"l+x z"@b.c><<<
<"l+x z"@b.c>
local=l, detail=x z
EOF
diff ${OUT} ${IN}

if test $? -ne 0
then
  ERRORS=`expr ${ERRORS} + 1`
fi

if test ${ERRORS} -eq 0
then
  rm -f ${IN} ${OUT} ${ERR}
fi

exit ${ERRORS}
