#!/bin/sh
# $Id: t-mts-acc-2.sh,v 1.17 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test access map restrictions and delay_checks
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

# create restrictions
${CAT} > ${ACC} <<EOF
cltaddr:${SM_LOCALHOST}	relay
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 16; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 12;
flags = {access, delay_checks};
daemon_address = localhost:${SRVPORT};
relay_from = "No.host.";
relay_to = "No.host.";
wait_for_server=4;
}
EOF


# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

${CAT} > ${MT} <<EOF
local.host	lmtp:
other.host	[127.0.0.1]
EOF

# run some test programs

# ----------------------------------------
# relaying allowed (client address) but not necessary
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender${TEST}@sm9.org -Ruser@local.host -E 0 -X 0 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# ----------------------------------------
# relaying allowed (client address)
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -Ssender${TEST}@sm9.org -Ruser@other.host -E 1 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi


# create restrictions
${CAT} > ${ACC} <<EOF
cltaddr:${SM_LOCALHOST}	quick:relay
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}


# ----------------------------------------
# relaying allowed (client address) but not necessary
TEST=3
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender${TEST}@sm9.org -Ruser@local.host -E 0 -X 0 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

# create restrictions
${CAT} > ${ACC} <<EOF
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

# ----------------------------------------
# relaying denied
TEST=4
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -Ssender${TEST}@sm9.org -Ruser@other.host -E 0 -X 0 -A 0
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi


# create restrictions
${CAT} > ${ACC} <<EOF
cltaddr:127	relay
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

# ----------------------------------------
# relaying allowed (client address)
TEST=5
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -Ssender${TEST}@sm9.org -Ruser@other.host -E 1 -X 1 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi



# ----------------------------------------
rm -f ${ACCMAP} ${ALIMAP} ${MTMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
