#!/bin/sh
# $Id: t-mts-dnsbl-0.sh,v 1.10 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test DNSBL
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP} ${ACCMAP}
# create access map for tests
${MM} -t'	' -F ${ACCMAP} <<EOF
sm9all:127.0.0.2	error:550 5.7.2 found 127.0.0.2 in sm9all
EOF

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar {
Log_Level = 12;
nameserver = ${NS};
DNS_timeout = 5;
dnsbl { domain = all.sm9.org.; tag = "sm9all"; }
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
flags= {access};
wait_for_server=4;
}
EOF

# ----------------------------------------
# reject by dnsbl
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'MAIL=error' ${CLTL} >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# reject by dnsbl, but delay
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar {
Log_Level = 12;
nameserver = ${NS};
DNS_timeout = 5;
dnsbl { domain = all.sm9.org.; tag = "sm9all"; }
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
daemon_address = localhost:${SRVPORT};
flags= {access, delay_checks};
wait_for_server=4;
}
EOF

if ${SHELL} ${SCRIPTS}/smtpcnf.sh -a '-d 8' -Z 'smtpc2' -c '-E' -E 0 -A 0 -X 0 $@ -S"s${TEST}@b.c" -R"r${TEST}@y.z"
then
    ERR=false
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'RCPT=error' ${CLTL} >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# clean up
rm -f ${MTMAP} ${ACCMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
