/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: dns.h,v 1.30 2005/09/02 06:22:38 ca Exp $
 */

#ifndef SM_DNS_H
#define SM_DNS_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/error.h"
#include "sm/cstr.h"
#include "sm/queue.h"
#include "sm/str.h"
#include "sm/cstr.h"
#include "sm/net.h"
#include "sm/nameser.h"
#include <resolv.h>
#include "sm/uio.h"	/* for writev() in sndrcv.c */

/*
**  The standard udp packet size PACKETSZ (512) is not sufficient for some
**  nameserver answers containing very many resource records. The resolver
**  may switch to tcp and retry if it detects udp packet overflow.
**  Also note that the resolver routines res_query and res_search return
**  the size of the *un*truncated answer in case the supplied answer buffer
**  it not big enough to accommodate the entire answer.
*/

#ifndef MAXPACKET
# define MAXPACKET 4096
#endif

#ifndef MAXMXHOSTS
# define MAXMXHOSTS	20
#endif

#ifndef MAXRESHOSTS
# define MAXRESHOSTS	20
#endif

#ifndef MAXDNSRCH
# define MAXDNSRCH	6	/* number of possible domains to search */
#endif

#ifndef RES_DNSRCH_VARIABLE
# define RES_DNSRCH_VARIABLE	_res.dnsrch
#endif

#ifndef NO_DATA
# define NO_DATA	NO_ADDRESS
#endif

#ifndef HFIXEDSZ
# define HFIXEDSZ	12	/* sizeof(HEADER) */
#endif

/* newer BIND versions use ns_t_* in an enum; should this be in configure? */
#ifndef T_MX
# define T_MX	ns_t_mx
#endif
#ifndef T_A
# define T_A	ns_t_a
#endif
#ifndef T_CNAME
# define T_CNAME	ns_t_cname
#endif
#ifndef T_PTR
# define T_PTR	ns_t_ptr
#endif

#define MAXCNAMEDEPTH	10	/* maximum depth of CNAME recursion */

#if defined(__RES) && (__RES >= 19940415)
# define RES_UNC_T	char *
#else
# define RES_UNC_T	uchar *
#endif

/* introduces errors into the resolver (for testing) */
#ifndef SM_LIBDNS_TEST
# define SM_LIBDNS_TEST	0
#endif

/*
**  DNS status codes
*/

/* XXX These must be coordinated with sm/error.h */
#ifndef DNS_ERR_BASE
# define DNS_ERR_BASE	512
#endif

#define DNSR_OK		SM_SUCCESS		/* query succeeded */

/* Authoritative Answer Host not found */
#define DNSR_NOTFOUND	sm_error_perm(SM_EM_DNS, DNS_ERR_BASE + 1)

/* Valid name, no data record of requested type */
#define DNSR_NO_DATA	sm_error_perm(SM_EM_DNS, DNS_ERR_BASE + 2)

/* query failed, try again */
#define DNSR_TEMP	sm_error_temp(SM_EM_DNS, DNS_ERR_BASE + 3)

/* query failed, don't retry */
#define DNSR_PERM	sm_error_perm(SM_EM_DNS, DNS_ERR_BASE + 4)

/* query timed out */
#define DNSR_TIMEOUT	sm_error_temp(SM_EM_DNS, DNS_ERR_BASE + 5)

/* recursion needed (XXX: Unused?) */
#define DNSR_RECURSE	sm_error_temp(SM_EM_DNS, DNS_ERR_BASE + 6)

/* MX record invalid */
#define DNSR_MXINVALID	sm_error_temp(SM_EM_DNS, DNS_ERR_BASE + 7)

/* PTR record invalid */
#define DNSR_PTRINVALID	sm_error_temp(SM_EM_DNS, DNS_ERR_BASE + 8)

/* CNAME record invalid */
#define DNSR_CNINVALID	sm_error_temp(SM_EM_DNS, DNS_ERR_BASE + 9)

#define DNS_H_ERR_BASE	(DNS_ERR_BASE + 9)

#define DNS_TIMEOUT	2

#if 0
typedef struct dns_rslv_ctx_S	dns_rslv_ctx_T, *dns_rslv_ctx_P;
#endif
typedef struct dns_mgr_ctx_S	dns_mgr_ctx_T, *dns_mgr_ctx_P;

typedef struct dns_mx_S		dns_mx_T, *dns_mx_P;
typedef struct dns_mxe_S	dns_mxe_T, *dns_mxe_P;
typedef struct dns_mxl_S	dns_mxl_T, *dns_mxl_P;

typedef struct dns_req_S	dns_req_T, *dns_req_P;
typedef struct dns_rql_S	dns_rql_T, *dns_rql_P;

typedef struct dns_res_S	dns_res_T, *dns_res_P;
typedef struct dns_resl_S	dns_resl_T, *dns_resl_P;
typedef struct dns_rese_S	dns_rese_T, *dns_rese_P;

typedef sm_ret_T (dns_callback_F)(dns_res_P, void *);

/* C type for DNS type */
typedef ushort	dns_type_T;

#if 0
sm_ret_T dns_rslv_new(uint _randv, dns_rslv_ctx_P *_pdns_rslv_ctx);
sm_ret_T dns_rslv_free(dns_rslv_ctx_P _dns_rslv_ctx);
#else
sm_ret_T dns_rslv_new(uint _randv);
#define dns_rslv_free(dns_rslv_ctx)	SM_SUCCESS
#endif

sm_ret_T dns_rese_new(const uchar *rrname, size_t _l, dns_type_T _type, uint _ttl, ushort _pref, ushort _weight, const uchar *_reshost, size_t _n, ipv4_T _ipv4, dns_rese_P *_pdns_rese);
sm_ret_T dns_rese_free(dns_rese_P _dns_rese);
sm_ret_T dns_res_new(uint _maxentries, dns_res_P *_pdns_res);
sm_ret_T dns_resl_free(dns_res_P _dns_res);
sm_ret_T dns_res_free(dns_res_P _dns_res);

sm_ret_T dns_decode(sm_str_P _ans, uchar *_query, int _qlen, dns_type_T *_ptype, dns_res_P _dns_res);

ushort	 mxrand(const uchar *_host);

char *dnstype2txt(dns_type_T _type);

#endif /* SM_DNS_H */
