/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id:$
 */

#ifndef SM_DNS_REQ_H
#define SM_DNS_REQ_H

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/dns.h"

/*
**  DNS request context
*/

typedef struct dns_res_S	dns_res_T, *dns_res_P;
typedef struct dns_req_S	dns_req_T, *dns_req_P;
typedef sm_ret_T (dns_callback_F)(dns_res_P, void *);

struct dns_req_S
{
	sm_str_P	*dnsreq_query;
	int		 dnsreq_type;		/* operating flags */
	dns_callback_F	 dnsreq_fct;
	void		*dnsreq_ctx;
};

struct dns_res_S
{
	sm_str_P	*dnsres_query;
	int		 dnsres_type;		/* operating flags */

	/* XXX union of various results... */
	dns_mx_T	 dnsres_mx;
};


#endif /* ! SM_DNS_REQ_H */
