/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: rfc2822.h,v 1.13 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_RFC2822_H
#define SM_RFC2822_H 1

#include "sm/generic.h"
#include "sm/str.h"

/*

RFC 2822

NO-WS-CTL       =       %d1-8 /         ; US-ASCII control characters
                        %d11 /          ;  that do not include the
                        %d12 /          ;  carriage return, line feed,
                        %d14-31 /       ;  and white space characters
                        %d127
text            =       %d1-9 /         ; Characters excluding CR and LF
                        %d11 /
                        %d12 /
                        %d14-127 /
                        obs-text
specials        =       "(" / ")" /     ; Special characters used in
                        "<" / ">" /     ;  other parts of the syntax
                        "[" / "]" /
                        ":" / ";" /
                        "@" / "\" /
                        "," / "." /
                        DQUOTE
FWS             =       ([*WSP CRLF] 1*WSP) /   ; Folding white space
                        obs-FWS
ctext           =       NO-WS-CTL /     ; Non white space controls
                        %d33-39 /       ; The rest of the US-ASCII
                        %d42-91 /       ;  characters not including "(",
                        %d93-126        ;  ")", or "\"
ccontent        =       ctext / quoted-pair / comment
comment         =       "(" *([FWS] ccontent) [FWS] ")"
CFWS            =       *([FWS] comment) (([FWS] comment) / FWS)
atext           =       ALPHA / DIGIT / ; Any character except controls,
                        "!" / "#" /     ;  SP, and specials.
                        "$" / "%" /     ;  Used for atoms
                        "&" / "'" /
                        "*" / "+" /
                        "-" / "/" /
                        "=" / "?" /
                        "^" / "_" /
                        "`" / "{" /
                        "|" / "}" /
                        "~"
atom            =       [CFWS] 1*atext [CFWS]
dot-atom        =       [CFWS] dot-atom-text [CFWS]
dot-atom-text   =       1*atext *("." 1*atext)
qtext           =       NO-WS-CTL /     ; Non white space controls
                        %d33 /          ; The rest of the US-ASCII
                        %d35-91 /       ;  characters not including "\"
                        %d93-126        ;  or the quote character
qcontent        =       qtext / quoted-pair
quoted-string   =       [CFWS]
                        DQUOTE *([FWS] qcontent) [FWS] DQUOTE
                        [CFWS]
word            =       atom / quoted-string
phrase          =       1*word / obs-phrase
address         =       mailbox / group
mailbox         =       name-addr / addr-spec
name-addr       =       [display-name] angle-addr
angle-addr      =       [CFWS] "<" addr-spec ">" [CFWS] / obs-angle-addr
group           =       display-name ":" [mailbox-list / CFWS] ";"
                        [CFWS]
display-name    =       phrase
mailbox-list    =       (mailbox *("," mailbox)) / obs-mbox-list
address-list    =       (address *("," address)) / obs-addr-list
addr-spec       =       local-part "@" domain
local-part      =       dot-atom / quoted-string / obs-local-part
domain          =       dot-atom / domain-literal / obs-domain
domain-literal  =       [CFWS] "[" *([FWS] dcontent) [FWS] "]" [CFWS]
dcontent        =       dtext / quoted-pair
dtext           =       NO-WS-CTL /     ; Non white space controls
                        %d33-90 /       ; The rest of the US-ASCII
                        %d94-126        ;  characters not including "[",
                                        ;  "]", or "\"

to              =       "To:" address-list CRLF

*/

/* type of element, values below T2822_MIN stand for themselves */
#define T2822_MIN	T2821_MIN
#define T2822_ATOM	T2821_ATOM
#define T2822_LITERAL	T2821_LITERAL
#define T2822_QUOTED	T2821_QUOTED
#define T2822_COMMENT	T2821_COMMENT
#define T2822_ENDTOK	T2821_ENDTOK

#define T2822_COMMA	T2821_COMMA
#define T2822_AT	T2821_AT
#define T2822_DOT	T2821_DOT
#define T2822_LEFT	T2821_LEFT
#define T2822_RIGHT	T2821_RIGHT
#define T2822_SEMI	T2821_SEMI
#define T2822_COLON	T2821_COLON

typedef struct sm_2822_S	sm_2822_T, *sm_2822_P;

struct sm_2822_S
{
	int		sm_2822_type;
	sm_str_P	sm_2822_val;
	/* XXX use TAILQ ? */
	sm_2822_P	sm_2822_next;
	sm_2822_P	sm_2822_prev;
};

typedef struct sm_2822_a_S	sm_2822_a_T, *sm_2822_a_P;

struct sm_2822_a_S
{
	sm_2822_P	sm_2822a_t;
	uint		sm_2822a_len;
	uint		sm_2822a_a;
};

int	atomtype(uchar _ch);
int	t2822_unparse(sm_str_P _sa, sm_2822_a_P _ta);
int	t2822_unquote(sm_str_P _sa, sm_2822_a_P _ta);
sm_ret_T t2822_parse(sm_2822_a_T *_ta, sm_str_P _sa);
int	t2822_addrlist(sm_2822_a_P _taout, sm_2822_a_P _taaddr, sm_2822_a_P _ta);

#endif /* SM_RFC2822_H */
