/*
 * Copyright (c) 2000-2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: rpool-int.h,v 1.7 2005/06/16 00:09:34 ca Exp $
 */

/*
**  resource pools
**  See rpool.html for documentation.
*/

#ifndef SM_RPOOL_INT_H
#define SM_RPOOL_INT_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/heap.h"
#include "sm/string.h"

/*
**  Each memory pool object consists of an sm_rp_plink_T,
**  followed by a platform specific amount of padding,
**  followed by 'poolsize' bytes of pool data,
**  where 'poolsize' is the value of rpool->sm_rp_poolsize at the time
**  the pool is allocated.
*/

typedef struct sm_rp_plink sm_rp_plink_T;
struct sm_rp_plink
{
	sm_rp_plink_T	*sm_rp_pnext;
};

typedef union
{
	sm_rp_plink_T	sm_ph_link;
	char		sm_ph_align[SM_ALIGN_SIZE];
} sm_rp_hdr_T;

/* resource type for rpools */
typedef struct sm_rp_rsrc sm_rp_rsrc_T;
struct sm_rp_rsrc
{
	/*
	**  Function for freeing this resource.  It may be NULL,
	**  meaning that this resource has already been freed.
	*/

	sm_rp_rsrcfree_T	 sm_rfree;
	void			*sm_rcontext;	/* resource data */
};

#define SM_RLIST_MAX 63

typedef struct sm_rp_rlist sm_rp_rlist_T;
struct sm_rp_rlist
{
	sm_rp_rsrc_T	 sm_rpl_vec[SM_RLIST_MAX];
	sm_rp_rlist_T	*sm_rpl_next;
};

struct sm_rpool_S
{
	/* SM_RPOOL_MAGIC, or is 0 if rpool is freed. */
	sm_magic_T	sm_magic;

	/*
	**  If this rpool object has no parent, then sm_rp_parent
	**  is NULL.  Otherwise, we set *sm_rp_parent = NULL
	**  when this rpool is freed, so that it isn't freed a
	**  second time when the parent is freed.
	*/

	sm_rp_rsrcfree_T	*sm_rp_parent;

	/*
	**  Memory pools
	*/

	/* Size of the next pool to be allocated, not including the header. */
	size_t		sm_rp_poolsize;

	/*
	**  If an sm_rpool_malloc request is too big to fit in the current
	**  pool, and the requested size is greater than bigobjectsize,
	**  then the object will be given its own malloc'ed block.
	**  sm_rp_bigobjsize <= sm_rp_poolsize.  The maximum wasted space
	**  at the end of a pool is maxpooledobjectsize - 1.
	*/

	size_t		sm_rp_bigobjsize;

	/* Points to next free byte in the current pool. */
	char	*sm_rp_ptr;

	/*
	**  Number of bytes available in the current pool.
	**	Initially 0. Set to 0 by sm_rpool_delete.
	*/

	size_t		sm_rp_avail;

	/* Maximum size of memory pools. */
	size_t		sm_rp_maxsize;

	/* Current size of entire pool. */
	size_t		sm_rp_totsize;

	/* Linked list of memory pools.  Initially NULL. */
	sm_rp_plink_T	*sm_rp_pools;

	/*
	** Resource lists
	*/

	sm_rp_rsrc_T	*sm_rp_rptr; /* Points to next free resource slot. */

	/*
	**  Number of available resource slots in current list.
	**	Initially 0. Set to 0 by sm_rpool_delete.
	*/

	size_t		sm_rp_ravail;

	/* Linked list of resource lists. Initially NULL. */
	sm_rp_rlist_T	*sm_rp_rlists;

#if _FFR_PERF_RPOOL
	int	sm_rp_nbigblocks;
	int	sm_rp_npools;
#endif /* _FFR_PERF_RPOOL */

};

#endif /* ! SM_RPOOL_INT_H */
