/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sockcnfdef.h,v 1.9 2005/08/24 20:54:09 ca Exp $
 */

#ifndef SM_SOCKCNFDEF_H
#define SM_SOCKCNFDEF_H 1

#include "sm/generic.h"
#include "sm/net.h"
#include "sm/sm-conf.h"

#if SM_SOCKCNFDEF
#define EXTERN
#else
#define EXTERN extern
#endif

EXTERN
sm_conf_definition_T
const sock_types[]
#if SM_SOCKCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
  "unix",	sm_conf_type_choice_value, SOCK_TYPE_UNIX
	, 0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
  "local",	sm_conf_type_choice_value, SOCK_TYPE_UNIX
	, 0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
  "inet",	sm_conf_type_choice_value, SOCK_TYPE_INET
	, 0, NULL, 0, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
  "inet6",	sm_conf_type_choice_value, SOCK_TYPE_INET6
	, 0, NULL, 0, NULL, NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SOCKCNFDEF */
;

EXTERN
sm_conf_definition_T
unix_sock_spec_defs[]
#if SM_SOCKCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
  "type", sm_conf_type_choice,
	offsetof(sockspec_T, sckspc_type), sizeof(sock_type_T),
	NULL, SM_CONF_FLAG_STRICTLY_REQUIRED, sock_types,
	NULL, NULL, "socket type" },

{ SM_CONF_DEF_MAGIC,
  "path", sm_conf_type_string,
	offsetof(sockspec_T, sock_unix.unixsckspc_path), 0,
	NULL, SM_CONF_FLAG_KEEP_DEFAULT, NULL, NULL, NULL,
	"pathname of Unix domain socket" },

{ SM_CONF_DEF_MAGIC,
  "umask",	sm_conf_type_u32,
	offsetof(sockspec_T, sock_unix.unixsckspc_umask),
	sizeof(mode_t),	"007",	0,	NULL,	NULL,	NULL,
	"umask to set before bind(2) and to set socket permissions" },
{ SM_CONF_DEF_MAGIC,
  "user",	sm_conf_type_string,
	offsetof(sockspec_T, sock_unix.unixsckspc_user),
	0,		 "",	0,	NULL,	NULL,	NULL,
	"owner of socket"	},
{ SM_CONF_DEF_MAGIC,
  "group",	sm_conf_type_string,
	offsetof(sockspec_T, sock_unix.unixsckspc_group),
	0,		 "", 0,	NULL,	NULL,	NULL,
	"group of socket"	},

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SOCKCNFDEF */
;

EXTERN
sm_conf_definition_T
inet_sock_spec_defs[]
#if SM_SOCKCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
  "type", sm_conf_type_choice,
	offsetof(sockspec_T, sckspc_type), sizeof(sock_type_T),
	NULL, SM_CONF_FLAG_STRICTLY_REQUIRED, sock_types, NULL, NULL,
	"socket type" },

{ SM_CONF_DEF_MAGIC,
  "port", sm_conf_type_u32,
	offsetof(sockspec_T, sock_inet.inetsckspc_port), sizeof(int),
	NULL, SM_CONF_FLAG_KEEP_DEFAULT|SM_CONF_FLAG_STRICTLY_REQUIRED,
	NULL, NULL, NULL,
	"port to listen on"	},

{ SM_CONF_DEF_MAGIC,
  "address", sm_conf_type_ipv4,
	offsetof(sockspec_T, sock_inet.inetsckspc_addr),
	sizeof(ipv4_T),
	"0.0.0.0", SM_CONF_FLAG_KEEP_DEFAULT, NULL, NULL, NULL,
	"bind to this IPv4 address" },

	/* Sentinel */
	{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SOCKCNFDEF */
;

EXTERN
sm_conf_definition_T
sock_spec_definitions[]
#if SM_SOCKCNFDEF
=
{
{ SM_CONF_DEF_MAGIC,
  "", sm_conf_type_union_type,
	offsetof(sockspec_T, sckspc_type), sizeof(sock_type_T),
	NULL, SM_CONF_FLAG_KEEP_DEFAULT, NULL, NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
  "type", sm_conf_type_union_choice,
	SOCK_TYPE_UNIX,	sizeof(sockspec_T),
	"unix", SM_CONF_FLAG_KEEP_DEFAULT, unix_sock_spec_defs,
	NULL, NULL, NULL },
{ SM_CONF_DEF_MAGIC,
  "type", sm_conf_type_union_choice,
	SOCK_TYPE_INET, sizeof(sockspec_T),
	"inet", SM_CONF_FLAG_KEEP_DEFAULT, inet_sock_spec_defs,
	NULL, NULL, NULL },

/* Sentinel */
{ SM_CONF_DEF_MAGIC, NULL, 0, 0, 0, NULL, 0, NULL, NULL, NULL, NULL }
}
#endif /* SM_SOCKCNFDEF */
;

#undef EXTERN

#endif /* SM_SOCKCNFDEF_H */
