#!/bin/sh
# $Id: t-cdb-0.sh,v 1.6 2004/12/29 23:41:26 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# test program for cdb: creates directory structure and then invokes
# t-cdb-0 with various -b parameters (and without).

test -s stop && exit 1              

SUB=sub

# create queue directories
for i in 0 1 2 3 4 5 6 7 8 9 A B C D E F
do
  if test -d ${i}
  then
    rm -f ${i}/S00*
  else
    mkdir ${i}
  fi
done

ERRS=0
DIR=`pwd`
DIRSUB=`pwd`/${SUB}

if ./t-cdb-0
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
fi

# delete queue files
#rm -f [0-9A-F]/S00*

if ./t-cdb-0 -b ${DIR}/
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
fi

# go one level down
test -d ${SUB} || mkdir ${SUB}
cd ${SUB} || exit 1

if ../t-cdb-0 -b ${DIR}/
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
fi

# create queue directories in subdirectory
for i in 0 1 2 3 4 5 6 7 8 9 A B C D E F
do
  if test -d ${i}
  then
    rm -f ${i}/S00*
  else
    mkdir ${i}
  fi
done

# back to original directory
cd ..

# access CDB in subdirectory, absolute path
if ./t-cdb-0 -b ${DIRSUB}/
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
fi

# access CDB in subdirectory, relative path
if ./t-cdb-0 -b ${SUB}/
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
fi

# delete queue directories in subdirectory
rmdir ${SUB}/[0-9A-F]
rmdir ${SUB}

# delete queue directories
rmdir [0-9A-F]

exit ${ERRS}
