/*
 * Copyright (c) 2002-2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-rcb-add.c,v 1.9 2004/12/29 23:47:32 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/ctype.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"
#include "sm/rcb.h"
#include "sm/check.h"

#include <stdio.h>

extern int Verbose;

#define ISHEXALPHA(c) (((c) >= 'a' && (c) <= 'f') || ((c) >= 'A' && (c) <= 'F'))

/*
**  ADDINT -- read an integer value from stdin and add it to the RCB
**
**	Parameters:
**		rcb -- RCB
**
**	Returns:
**		usual sm_error code (well, almost)
*/

sm_ret_T
addint(sm_rcb_P rcb)
{
	int c, base;
	uint32_t val;
	sm_ret_T ret;

	val = 0;
	base = 10;
	while ((c = getchar()) != EOF)
	{
		if (isdigit(c))
		{
			val = val * base + c - '0';
		}
		else if (base == 16 && ISHEXALPHA(c))
		{
			val = val * base + tolower(c) - 'a' + 10;
		}
		else if (val == 0 && (c == 'x' || c == 'X'))
		{
			base = 16;
		}
		else
		{
			if (Verbose > 3)
			{
				if (base == 10)
					fprintf(stderr, "putint: %u\n", val);
				else
					fprintf(stderr, "putint: %#x\n", val);
			}
			ret = sm_rcb_putuint32(rcb, val);
			return ret;
		}
	}
	return -1;
}

/*
**  ADDSTR -- read a string from stdin and add it to the RCB
**
**	Parameters:
**		rcb -- RCB
**
**	Returns:
**		usual sm_error code (well, almost)
*/

sm_ret_T
addstr(sm_rcb_P rcb)
{
	int c, i;
	bool esc;
	sm_ret_T ret;
	char buf[SM_BUFSIZE];

	i = 0;
	esc = false;
	while ((c = getchar()) != EOF && i < sizeof(buf) - 2)
	{
		if (esc)
			buf[i++] = (char) c;
		else if (c == '\\')
			esc = true;
		else if (isspace(c))
		{
			if (Verbose > 3)
			{
				buf[i] = '\0';
				fprintf(stderr, "putstr: '%s'\n", buf);
			}
			ret = sm_rcb_putn(rcb, (uchar *) buf, i);
			if (Verbose > 1)
				fprintf(stderr, "clt: putn: len=%d, rd=%d\n",
					i, (int) sm_rcb_getlen(rcb));
			return ret;
		}
		else
			buf[i++] = (char) c;
	}
	return -1;
}
