/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: sm-conf-type-node.c,v 1.8 2005/05/24 17:57:28 ca Exp $")

#if SM_LIBCONF_ALONE
#include <ctype.h>
#include <string.h>
#include "sm-conf.h"
#include "sm-conf-util.h"
#else /* SM_LIBCONF_ALONE */
#include "sm/ctype.h"
#include "sm/string.h"
#include "sm/sm-conf.h"
#include <stdio.h>
#endif /* SM_LIBCONF_ALONE */

#include "sm-conf-node.h"
#include "sm-conf-state.h"
#include "sm-conf-type.h"

static int
sm_conf_type_node_node_to_value(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	sm_conf_node_T			*node,
	void				*data)
{
	if (data != NULL)
		*(sm_conf_node_T const **)data = node;
	return 0;
}

static int
sm_conf_type_node_value_check(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	void const			*data)
{
	SM_IS_CONF_DEF(def);
	if (data == NULL)
		return 0;

	/* if we have a check function, use it. */
	if (def->scd_check != NULL)
		return (* def->scd_check)(smc, def->scd_check_data, def, data);
	return 0;
}

static int
sm_conf_type_node_value_null(
	sm_conf_T			*smc,
	sm_conf_definition_T const	*def,
	void				*data)
{
	if (data != NULL)
		*(sm_conf_node_T const **)data = NULL;
	return 0;
}

sm_conf_type_T const
sm_conf_type_node_data =
{
	sm_conf_type_node_node_to_value,
	sm_conf_type_node_value_check,
	sm_conf_type_node_value_null
};
