/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: bhtmap.c,v 1.3 2005/01/17 21:46:08 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "bhtable.h"

/* Minimum size for a hash table */
#define BHT_MIN_SIZE	13

/*
**  BHT_CREATE - allocate hash table
**
**	Parameters:
**		ptable -- (pointer to) table (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_bht_create(sm_bht_P *ptable)
{
	sm_bht_P table;

	SM_REQUIRE(ptable != NULL);
	table = (sm_bht_P) sm_zalloc(sizeof(*table));
	if (table == NULL)
		return sm_error_temp(SM_EM_HT, ENOMEM);
	*ptable = table;
	return SM_SUCCESS;
}

/*
**  BHT_SETOPT - set values for hash table
**
**	Parameters:
**		htsize -- size of hash table
**		limit -- maximum size of hash table
**
**	Returns:
**		SM_SUCCESS
*/

sm_ret_T
sm_bht_setopt(sm_bht_P table, uint htsize, uint limit)
{
	SM_REQUIRE(table != NULL);
	if (htsize > 0)
		table->bht_size = htsize;
	if (limit > 0)
		table->bht_limit = limit;
	return SM_SUCCESS;
}

/*
**  BHT_GETOPT - get values from hash table
**
**	Parameters:
**		phtsize -- size of hash table
**		plimit -- maximum size of hash table
**
**	Returns:
**		SM_SUCCESS
*/

sm_ret_T
sm_bht_getopt(sm_bht_P table, uint *phtsize, uint *plimit)
{
	SM_REQUIRE(table != NULL);
	if (phtsize != NULL)
		*phtsize = table->bht_size;
	if (plimit != NULL)
		*plimit = table->bht_limit;
	return SM_SUCCESS;
}

/*
**  BHT_OPEN - open hash table
**
**	Parameters:
**		ptable -- (pointer to) table (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_bht_open(sm_bht_P *ptable)
{
	sm_ret_T ret;
	sm_bht_P table;

	SM_REQUIRE(ptable != NULL);
	table = *ptable;
	if (table == NULL)
	{
		ret = sm_bht_create(ptable);
		if (!sm_is_success(ret))
			return ret;
	}
	ret = bht_init(table, table->bht_size);
	if (!sm_is_success(ret))
	{
		sm_free((void *) table);
		*ptable = NULL;
	}
	return ret;
}
