/*
 * Copyright (c) 2002, 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbgetnstr.c,v 1.10 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"
#include "sm/rcb.h"

/*
**  SM_RCB_GETNSTR -- Create new str object from rcb (n bytes).
**
**	Parameters:
**		rcb -- sm_rcb_P object to read from.
**		str -- pointer to str.
**		n -- number of bytes to copy (aligned to 4 bytes).
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_NS
**
**	Side Effects: none on error
**
**	Last code review: 2005-03-18 18:20:00
**	Last code change: 2005-03-18 18:17:38
*/

sm_ret_T
sm_rcb_getnstr(sm_rcb_P rcb, sm_str_P *str, uint n)
{
	uint la;

	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
	SM_REQUIRE(str != NULL);
	SM_REQUIRE(n < INT_MAX);
	la = SM_ALIGN4(n);
	SM_ASSERT(la >= n);
	SM_ASSERT(rcb->sm_rcb_rw >= 0);
	SM_ASSERT((uint)rcb->sm_rcb_rw + la >= (uint)rcb->sm_rcb_rw);
	if ((uint)rcb->sm_rcb_rw + la > rcb->sm_rcb_len)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);
	SM_ASSERT(rcb->sm_rcb_rw + la < INT_MAX);
	*str = sm_str_new(NULL, la, la + 4);
	if (*str == NULL)
		return sm_error_temp(SM_EM_RECCOM, ENOMEM);
	sm_memcpy((void *) (*str)->sm_str_base,
		rcb->sm_rcb_base + rcb->sm_rcb_rw, n);
	(*str)->sm_str_len = n;
	rcb->sm_rcb_rw += la;
	return SM_SUCCESS;
}
