/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: str2file.c,v 1.5 2005/07/21 20:05:24 ca Exp $")
#include "sm/io.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "io-int.h"

/*
**  SM_STR2FILE -- embed a str in a file
**
**	Parameters:
**		str -- str
**		fp -- file which will be filed in (in/output)
**
**	Returns:
**		SM_SUCCESS
*/

sm_ret_T
sm_str2file(sm_str_P str, sm_file_T *fp)
{
	uint n, l;

	SM_REQUIRE(str != NULL);
	SM_REQUIRE(fp != NULL);

	/* While snprintf(3) specifies size_t stdio uses an int internally */
	l = sm_str_getlen(str);
	n = sm_str_getmax(str) - l;
	if (n > INT_MAX)
		n = INT_MAX;
	/* should this return an error instead? */

	fp->sm_magic = SM_FILE_MAGIC;
	f_fd(*fp) = -1;
	f_flags(*fp) = SMWR|SMSTRSTR;
	fp->f_cookie = (void *)str;
	f_bfbase(*fp) = f_p(*fp) = str->sm_str_base;
	f_bfsize(*fp) = f_w(*fp) = n ? n - 1 : 0;
	fp->f_timeout = SM_TIME_FOREVER;
	f_read(*fp) = NULL;
	f_write(*fp) = NULL;
	f_close(*fp) = NULL;
	f_open(*fp) = NULL;
	f_seek(*fp) = NULL;
	f_setinfo(*fp) = f_getinfo(*fp) = NULL;
	return SM_SUCCESS;
}
