/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: stsock.c,v 1.7 2005/01/11 21:42:04 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "statethreads/st.h"
#include "sm/rcbst.h"
#include "sm/fcntl.h"
#include "sm/unixsock.h"
#include "sm/stsock.h"

/*
**  UN_ST_SOCKET_CLOSE  -- close a state threads network socket
**
**	Parameters:
**		sock -- socket to close
**
**	Returns:
**		usual return code
*/

sm_ret_T
un_st_socket_close(st_netfd_t sock)
{
	int r;

	r = st_netfd_close(sock);
	return (r == -1) ? sm_error_perm(SM_EM_STTHRIO, errno) : SM_SUCCESS;
}

/*
**  UN_ST_CLIENT_CONNECT -- connect to a Unix socket
**
**	Parameters:
**		name -- name of socket
**		tmo -- timeout
**		fd -- pointer to net fd (output)
**
**	Returns:
**		usual return code
*/

sm_ret_T
un_st_client_connect(const char *name, st_utime_t tmo, st_netfd_t *fd)
{
	int sockfd;
	size_t len;
	st_netfd_t nfd;
	struct sockaddr_un servaddr;

	SM_REQUIRE(name != NULL);
	SM_REQUIRE(fd != NULL);

	*fd = NULL;	/* be nice to callers (in case of errors) */
	sockfd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sockfd == -1)
		return sm_error_perm(SM_EM_STTHRIO, errno);

	sm_memset(&servaddr, '\0', sizeof(servaddr));
	servaddr.sun_family = AF_UNIX;
	len = strlen(name);
	if (len >= sizeof servaddr.sun_path)
		return sm_error_perm(SM_EM_STTHRIO, EINVAL);
	(void) strlcpy(servaddr.sun_path, name, sizeof servaddr.sun_path);
#if HAVE_SOCK_UN_SUN_LEN
	servaddr.sun_len = len;
#endif

	nfd = st_netfd_open_socket(sockfd);
	if (nfd == NULL)
		return sm_error_perm(SM_EM_STTHRIO, errno);
	if (st_connect(nfd, (struct sockaddr *) &servaddr,
		     sizeof(servaddr), tmo) == -1)
	{
		int err;

		err = errno;
		(void) st_netfd_close(nfd);
		return sm_error_perm(SM_EM_STTHRIO, err);
	}

	*fd = nfd;
	return SM_SUCCESS;
}
