/*
 * Copyright (c) 2000-2002, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: wbuf.c,v 1.9 2005/05/09 18:16:42 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "io-int.h"

/* Note: This function is called from a macro located in <sm/io.h> */

/*
**  SM_WBUF -- write character to and flush (likely now full) buffer
**
**  Write the given character into the (probably full) buffer for
**  the given file.  Flush the buffer out if it is or becomes full.
**
**	Parameters:
**		fp -- the file pointer
**		c -- int representation of the character to add
**
**	Results:
**		Failure: sm_error
**		Success: int value of 'c' (uchar)
*/

sm_ret_T
sm_wbuf(sm_file_T *fp, int c)
{
	int n;
	sm_ret_T ret;

	/*
	**  In case we cannot write, or longjmp takes us out early,
	**  make sure w is 0 so that we will get called again.
	**  If we did not do this, a sufficient number of sm_io_putc()
	**  calls might wrap w from negative to positive.
	*/

	f_w(*fp) = 0;
	if (cantwrite(fp))
		return sm_error_perm(SM_EM_IO, EBADF);
	c = (uchar) c;

	/*
	**  If it is completely full, flush it out.  Then, in any case,
	**  stuff c into the buffer.  If this causes the buffer to fill
	**  completely flush it (perhaps a second time).  The second flush
	**  will always happen on unbuffered streams, where bf.smb_size==1;
	**  sm_io_flush() guarantees that sm_io_putc() will always call
	**  sm_wbuf() by setting w to 0, so we don't need to do anything else.
	*/

	n = f_p(*fp) - f_bfbase(*fp);
	if (n >= f_bfsize(*fp))
	{
		ret = sm_io_flush(fp);
		if (sm_is_err(ret))
			return ret;
		n = 0;
	}
	if (f_w(*fp) <= 0 && (f_flags(*fp) & (SMSTR|SMSTRSTR)) != 0)
		return c; /* sm_err_perm(SM_IO, SM_E_OVFLW_NS); */
	f_w(*fp)--;
	*f_p(*fp)++ = c;
	if (++n == f_bfsize(*fp))
	{
		ret = sm_io_flush(fp);
		if (sm_is_err(ret))
			return ret;
	}
	return c;
}
