/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_freemacros.c,v 1.4 2005/06/21 17:46:06 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"

#if SM_USE_PMILTER
/*
**  SM_PMILT_FREEMACROS -- Free all macros starting at a certain "stage"
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		where -- stage
**
**	Returns:
**		always SM_SUCCESS
*/

sm_ret_T
sm_pmilt_freemacros(pmse_ctx_P pmse_ctx, uint where)
{
	uint i, j;

	SM_IS_PMSE_CTX(pmse_ctx);
	for (i = where; i < PM_SMST_MAX; i++)
		for (j = 0; j < PM_MAX_MACROS; j++)
			SM_STR_FREE(pmse_ctx->pmse_mac_values[i][j]);
	return SM_SUCCESS;
}
#endif /* SM_USE_PMILTER */
