/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: reverse.h,v 1.16 2005/10/04 06:02:45 ca Exp $
 */

#ifndef REVERSE_H
#define REVERSE_H 1

#include "sm/generic.h"
#include "sm/net.h"
#include "sm/evthr.h"
#include "sm/rpool.h"
#include "sm/rcb.h"
#include "sm/rcbl.h"
#include "sm/rcbcomm.h"
#include "sm/queue.h"
#include "sm/bhtable.h"
#include "sm/pthread.h"
#include "sm/mta.h"
#include "sm/map.h"
#include "sm/log.h"
#include "sm/smar.h"

/* return all results? */
#define SMAR_RVRS_ALL	0

#ifndef SMAR_ARRDNS_A
#define SMAR_ARRDNS_A	0
#endif

typedef struct smar_rdns_S	smar_rdns_T, *smar_rdns_P;

struct smar_rdns_S
{
	sm_cstr_P	 arrdns_name;	/* name from DNS */
#if SMAR_ARRDNS_A
	int		 arrdns_n_a;	/* number of A records */
	ipv4_T		*arrdns_a;	/* pointer to list of A records */
#endif
};

/* callback function to return result */
typedef sm_ret_T (smar_rvrs_cb_F)(smar_rvrs_P, void *);

struct smar_rvrs_S
{
	/* no magic? */
	sessta_id_T	 arv_seid;	/* session/transaction id */
	ipv4_T		 arv_ipv4;	/* IPv4 addr */
	sm_str_P	 arv_pa;	/* printable in-addr.arpa addr */
	sm_ret_T	 arv_ret;	/* result */
	uint32_t	 arv_flags;	/* status of address resolving */
	uint32_t	 arv_ltype;	/* lookup type */
	uint32_t	 arv_lflags;	/* lookup flags */
	int		 arv_PTR_qsent;	/* number of PTR queries sent */
	int		 arv_PTR_rrcvd;	/* number of PTR records received */
	int		 arv_A_qsent;	/* number of A queries sent */
	int		 arv_A_rrcvd;	/* number of A responses received */
	int		 arv_n_a;	/* total number of A records */
	smar_rdns_T	*arv_res; /* array of results [0..arv_A_qsent-1] */
	sm_cstr_P	 arv_hostname;

	sm_rcbe_P	 arv_rcbe;	/* RCB to write back result */
	smar_ctx_P	 arv_smar_ctx;	/* pointer back to SMAR context */
	smar_clt_ctx_P	 arv_smar_clt_ctx; /* pointer back to client context */
#if 0
	sm_rpool_P	 arv_rpool;	/* for this context? */
#endif
	smar_rvrs_cb_F	*arv_cbf; /* callback fct to invoke to return result */
	void		*arv_cb_ctx;	/* context for callback function */
};

/* SMAR RVRS flags (A4: asked for) */
#define SMARV_FL_NONE	0x00000000	/* not yet OK */
#define SMARV_FL_TMPPTR	0x00000001	/* temporary error while resolving PTR */
#define SMARV_FL_TMPA	0x00000002	/* temporary error while resolving A */
#define SMARV_FL_PRMPTR	0x00000004	/* permanent error while resolving PTR */
#define SMARV_FL_PRMA	0x00000008	/* permanent error while resolving A */
#define SMARV_FL_MATCH	0x00000010	/* found match */
#define SMARV_FL_OK	0x00000020	/* resolved */
#define SMARV_FL_MASK	0x000000ff	/* return value mask */

#define SMARV_FL_A4PTR	0x00000100	/* asked for PTR records */
#define SMARV_FL_GOTPTR	0x00000200	/* got PTR records */
#define SMARV_FL_A4A	0x00000400	/* asked for A records */
#define SMARV_FL_GOTA	0x00000800	/* got A records */
#define SMARV_FL_C_A	0x00001000	/* got a CNAME record for A */
#define SMARV_FL_C_PTR	0x00002000	/* got a CNAME record for PTR */
/* use counters instead of flags?? */
#define SMARV_FL_C_A_L	0x00004000	/* CNAME loop for A */
#define SMARV_FL_C_PTR_L 0x00008000	/* CNAME loop for PTR */

#define SMARV_FL_NOSEND	0x00010000	/* do not send data */
#define SMARV_FL_NOFREE	0x00020000	/* do not free context */

#define SMARV_SET_FLAG(smar_rvrs, fl) (smar_rvrs)->arv_flags |= (fl)
#define SMARV_CLR_FLAG(smar_rvrs, fl) (smar_rvrs)->arv_flags &= ~(fl))
#define SMARV_IS_FLAG(smar_rvrs, fl) (((smar_rvrs)->arv_flags & (fl)) != 0)

sm_ret_T smar_rvrs_re(smar_rvrs_P _smar_rvrs, void *_ctx);
sm_ret_T smar_rvrs_new(smar_ctx_P _smar_ctx, smar_clt_ctx_P _smar_clt_ctx, smar_rvrs_P *_psmar_rvrs);
sm_ret_T smar_rvrs_free(smar_rvrs_P _smar_rvrs);
sm_ret_T smar_rvrs_rslv(smar_ctx_P _smar_ctx, smar_rvrs_P _smar_rvrs, uint _timeout);
const char *smar_rvrs_ret2char(smar_rvrs_P _smar_rvrs);

#endif /* REVERSE_H */
