#!/bin/sh
# $Id: t-smar-1.sh,v 1.16 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test MX/A expansion for RFC2821 addresses.
# Uses smar, t-smar.sh, DNS
# Note: this program relies on the sm9.org DNS server and some "quirks",
# unroutable addresses as name servers to create timeouts.
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

if test X"${SM_NO_DNS_HACK_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OK=smar.ok
rm -f ${SOCK} ${PIDS}
SKIP=""
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# ; test records
# ; pointing to existing host
# mxok.sm9.org.           IN      MX 10   server.sm9.org.
# ; pointing to non-existing host
# mxnonexistent.sm9.org.  IN      MX 10   nonexistent.sm9.org.
# ; pointing to two hosts: one exists the other doesn't
# mxhalfok0.sm9.org.      IN      MX 10   server.sm9.org.
# mxhalfok0.sm9.org.      IN      MX 20   nonexistent.sm9.org.
# ; pointing to two hosts: one exists the other doesn't
# mxhalfok1.sm9.org.      IN      MX 10   nonexistent.sm9.org.
# mxhalfok1.sm9.org.      IN      MX 20   server.sm9.org.
# ; pointing to two hosts: one exists the other doesn't
# mxhalfok2.sm9.org.      IN      MX 10   nonexistent.sm9.org.
# mxhalfok2.sm9.org.      IN      MX 10   server.sm9.org.
# ; how to create tempory errors?
# bogus.sm9.org has been delegated to 127.0.0.2 which shouldn't answer
# DNS requests -> timeout...
# mx.bogus.sm9.org.	should time out
# mxbogus.sm9.org.        IN      MX 10   server.bogus.sm9.org.
# ; pointing to IP address
# mxip.sm9.org.		21600	IN	MX 10	127.1.2.3.
# ; pointing to two IP addresses
# mxip2.sm9.org.		21600	IN	MX 10	127.1.2.4.
# mxip2.sm9.org.		21600	IN	MX 10	127.1.2.5.
# add records where one entry times out?

TEST=1
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a1@mxok.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'IP\[0\]=127.0.0.1 \[7f000001\]' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

TEST=2
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a2@mxnonexistent.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'WARN: lookup=(perm|notfound)' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

TEST=3
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a3@mxhalfok0.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'IP\[0\]=127.0.0.1 \[7f000001\]' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

TEST=4
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a4@mxhalfok1.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'IP\[0\]=127.0.0.1 \[7f000001\]' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

TEST=5
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a5@mxhalfok2.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'IP\[0\]=127.0.0.1 \[7f000001\]' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

# ; a bogus name server
# bogus.sm9.org.		IN	NS	bogusns.sm9.org.
# bogusns.sm9.org.	IN	A	127.0.0.2
# 
# ; test records
# ; pointing to host whose name server doesn't answer
# mx2at.sm9.org.		21600	IN	MX 10	server.bogus.sm9.org.
# ; pointing to two hosts: first exists second doesn't
# mx2ahalft0.sm9.org.	21600	IN	MX 10	server.sm9.org.
# mx2ahalft0.sm9.org.	21600	IN	MX 20	server.bogus.sm9.org.
# ; pointing to two hosts: first doesn't exists the other does
# mx2ahalft1.sm9.org.	21600	IN	MX 10	server.bogus.sm9.org.
# mx2ahalft1.sm9.org.	21600	IN	MX 20	server.sm9.org.
# ; pointing to two hosts: one exists the other doesn't
# mx2ahalft2.sm9.org.	21600	IN	MX 10	server.bogus.sm9.org.
# mx2ahalft2.sm9.org.	21600	IN	MX 10	server.sm9.org.
# ; MX pointing to invalid host: not accepted by nameserver, can't use it!
# mxinvalidhost.sm9.org.	IN	MX 10	invalid@host.sm9.org.
# ; pointing to IP address
# mxip.sm9.org.		21600	IN	MX 10	127.1.2.3.

TEST=6
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a6@mx.bogus.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'WARN: lookup=(timeout|temp_fail)' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

TEST=7
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a7@mx2at.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'WARN: lookup=(timeout|temp_fail)' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

TEST=8
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a8@mx2ahalft0.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'IP\[0\]=127.0.0.1 \[7f000001\]' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi


TEST=9
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
if test X"${SM_FULL_DNS_TEST}" != "X"
then
A='<a9@mx2ahalft1.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'WARN: lookup=timeout' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi
fi

TEST=10
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a10@mx2ahalft2.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'IP\[0\]=127.0.0.1 \[7f000001\]' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

TEST=11
# ----------------------------------------
if echo "${SKIP} X" | grep -v '\<'${TEST}'\>' > /dev/null
then
A='<a11@mxip.sm9.org>'
${SHELL} ${SD}/t-smar.sh -e 'WARN: lookup=(perm|notfound)' ${A}
ok=$?
if test ${ok} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed: ${A}"
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
else
  ${VERBOSE} && echo "$0: test ${TEST} OK"
fi
fi

exit ${ERRS}
