#!/bin/sh
# $Id: connctl.sh,v 1.5 2005/05/31 21:00:28 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
#

DIR=`dirname $0`
INP=${DIR}/cctl.1.gz
OUT=connctl.out.$$
OK=connctl.ok.$$
rm -f ${OUT} ${OK}

gunzip -c ${INP} | ${VALGRIND} ./t-connctl-0 -p | grep : > ${OUT}
cat > ${OK} <<EOF
total:      10616
colls:        266
maxcolls:       0
unused:         5
EOF
diff ${OUT} ${OK} || exit 1

gunzip -c ${INP} | ${VALGRIND} ./t-connctl-0 -p -h 1024 | grep : > ${OUT}
cat > ${OK} <<EOF
total:      10616
colls:          0
maxcolls:       0
unused:       735
EOF
diff ${OUT} ${OK} || exit 1

gunzip -c ${INP} | ${VALGRIND} ./t-connctl-0 -p -h 512 | grep : > ${OUT}
cat > ${OK} <<EOF
total:      10616
colls:          5
maxcolls:       0
unused:       226
EOF
diff ${OUT} ${OK} || exit 1


rm -f ${OUT} ${OK}
exit 0
