/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-getnextstring.c,v 1.3 2004/09/09 01:37:29 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"

extern char *sm_getnextstring(char **_cpp);

static void
test_harness(void)
{
	char *b, *c;
	char in[] = "this is a \"test \" for 'a b' simple \"scan ner\" !";
	char in2[] = "\"te't \" 'a \" b' 'scan \\' ner' !?";

	c = in;
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("this", b) == 0);

	b = sm_getnextstring(&c);
	SM_TEST(strcmp("is", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("a", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("test ", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("for", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("a b", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("simple", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("scan ner", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("!", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(b == NULL);

	c = in2;
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("te't ", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("a \" b", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("scan \\", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("ner'", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(strcmp("!?", b) == 0);
	b = sm_getnextstring(&c);
	SM_TEST(b == NULL);
}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test getnextstring");
	test_harness();
	return sm_test_end();
}
