/*
 * Copyright (c) 2001-2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */


#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-strto.c,v 1.10 2005/02/15 19:53:09 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"
#include "sm/types.h"
#include "sm/limits.h"
#include "sm/error.h"
#include "sm/string.h"

static void
test64(void)
{
	int i;
	uint j, l1;
	ulonglong_T ll, l2;
	uint list[] = { 0, 1, 16, 31, 32, 63, 64, 127, 128, 255, 256
		, 1023, 1024, 4095, 4096
		, 0x07FFFFFF, 0x0FFFFFFF, 0x08000000, 0x08000001
		, 0x17FFFFFF, 0x1FFFFFFF, 0x18000000, 0x18000001
		, 0x27FFFFFF, 0x2FFFFFFF, 0x28000000, 0x28000001
		, 0x37FFFFFF, 0x3FFFFFFF, 0x38000000, 0x38000001
		, 0x57FFFFFF, 0x5FFFFFFF, 0x58000000, 0x58000001
		, 0xA7FFFFFF, 0xAFFFFFFF, 0xA8000000, 0xA8000001
		, 0xE7FFFFFF, 0xEFFFFFFF, 0xE8000000, 0xE8000001
		, 0x7FFFFFFF, 0xFFFFFFFF };
	ulonglong_T llist[] = { 0ULL
		, 0x07FFFFFFULL
		, 0xFFFFFFFFULL
		, 0x1000000000000000ULL
		, 0x1000000000000001ULL
		, 0x1111111111111111ULL
		, 0x10000000FFFFFFFFULL
		, 0x1FFFFFFFFFFFFFFFULL
		, 0x2222222222222222ULL
		, 0x3333333333333333ULL
		, 0x4444444444444444ULL
		, 0x5555555555555555ULL
		, 0x6666666666666666ULL
		, 0x7777777777777777ULL
		, 0x8888888888888888ULL
		, 0x9999999999999999ULL
		, 0xAAAAAAAAAAAAAAAAULL
		, 0xBBBBBBBBBBBBBBBBULL
		, 0xCCCCCCCCCCCCCCCCULL
		, 0xDDDDDDDDDDDDDDDDULL
		, 0xEEEEEEEEEEEEEEEEULL
		, 0x7FFFFFFFFFFFFFFFULL
		, 0x8FFFFFFFFFFFFFFFULL
		, 0xFFFFFFFFFFFFFFFFULL
		};
	char buf[32];

	for (j = 0; j < SM_ARRAY_SIZE(list); j++)
	{
		l1 = list[j];
		i = sm_snprintf(buf, sizeof(buf), "%Y", l1);
		l2 = sm_strtoull(buf, NULL, 64);
		SM_TEST(l1 == l2);
		i = sm_snprintf(buf, sizeof(buf), "%Z", l1);
		l2 = sm_strtoull(buf, NULL, 32);
		SM_TEST(l1 == l2);
	}

	for (j = 0; j < 1024; j++)
	{
		l1 = j;
		i = sm_snprintf(buf, sizeof(buf), "%Y", l1);
		l2 = sm_strtoull(buf, NULL, 64);
		SM_TEST(l1 == l2);
		i = sm_snprintf(buf, sizeof(buf), "%Z", l1);
		l2 = sm_strtoull(buf, NULL, 32);
		SM_TEST(l1 == l2);
	}

	for (j = 0; j < SM_ARRAY_SIZE(llist); j++)
	{
		ll = llist[j];
		i = sm_snprintf(buf, sizeof(buf), "%qY", ll);
		l2 = sm_strtoull(buf, NULL, 64);
		SM_TEST(ll == l2);
	}
}


int
main(int argc, char *argv[])
{
	long int l;
	long long ll;
	unsigned long long ull;
	char buf[256];

	sm_test_begin(argc, argv, "test strto");

	l = LONG_MAX;
	sm_snprintf(buf, sizeof(buf), "%ld", l);
	errno = 0;
	l = strtol(buf, (char **) NULL, 10);
	SM_TEST(errno == 0 && l == LONG_MAX);

	l = LONG_MIN;
	sm_snprintf(buf, sizeof(buf), "%ld", l);
	errno = 0;
	l = strtol(buf, (char **) NULL, 10);
	SM_TEST(errno == 0 && l == LONG_MIN);

	l = LONG_MAX;
	sm_snprintf(buf, sizeof(buf), "%ld1", l);
	errno = 0;
	l = strtol(buf, (char **) NULL, 10);
	SM_TEST(errno == ERANGE && l == LONG_MAX);

	l = LONG_MIN;
	sm_snprintf(buf, sizeof(buf), "%ld1", l);
	errno = 0;
	l = strtol(buf, (char **) NULL, 10);
	SM_TEST(errno == ERANGE && l == LONG_MIN);

	ll = LLONG_MAX;
	sm_snprintf(buf, sizeof(buf), "%lld", ll);
	errno = 0;
	ll = sm_strtoull(buf, (char **) NULL, 10);
	SM_TEST(errno == 0 && ll == LLONG_MAX);

	ll = LLONG_MIN;
	sm_snprintf(buf, sizeof(buf), "%lld", ll);
	errno = 0;
	ll = sm_strtoull(buf, (char **) NULL, 10);
	SM_TEST(errno == 0 && ll == LLONG_MIN);

	ull = ULLONG_MAX;
	sm_snprintf(buf, sizeof(buf), "%llX", ull);
	errno = 0;
	ull = sm_strtoull(buf, (char **) NULL, 16);
	SM_TEST(errno == 0 && ull == ULLONG_MAX);

	test64();
	return sm_test_end();
}
