#!/bin/sh
# $Id: t-bounce-8.sh,v 1.7 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounce: bounce temporarily can't be delivered, get's "stuck" in queue
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-bounce-8.ok"
OUT="t-bounce-8.out"
EDBROK="../qmgr/t-bounce-edbr.ok"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
451: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# run some test programs

# ----------------------------------------
# permanent failure from SMTP sink; create a bounce; bounce is temporarily
# not deliverable, hence the original recipient is removed from DEFEDB
# and only the bounce rcpt is in DEFEDB.
# XXX why is perm=0 instead of 1?
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<r451@local.host>
	rcpts_tot=3
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<r451@local.host>
	aqr_rcpt_idx=2
	aqr_da_idx=0
	aqr_status=451
EOF
if ${SHELL} ${SD}/smtp1.sh -O ${EDBROK} -Sr451@local.host -R552@local.host -R553@local.host -i 10 -E 3 -X 0 -A 1 -s 10
then
  # check DEFEDB
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi

# ----------------------------------------
# permanent failure from SMTP sink; create a bounce; bounce is temporarily
# not deliverable, hence the original recipient is removed from DEFEDB
# and only the bounce rcpt is in DEFEDB.
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
rm -f ${MTMAP}
# two IP addresses where hopefully no server is listening
${CAT} > ${MT} <<EOF
noroute.host	[127.0.0.2] [127.0.0.3]
local.host	[127.0.0.1]
EOF
if ${SHELL} ${SD}/smtp1.sh -e -Sr451@noroute.host -R552@local.host -R553@local.host -i 10 -E 2 -X 0 -A 1 -s 10 -C '-O 2'
then
  # check DEFEDB
  EDBROUT=edbr.out
  EDBOUT=edb.out
  EDBOK=edbr.ok
  ${CAT} > ${EDBOK} <<EOF
got transaction
	mail=<r451@noroute.host>
	rcpts_tot=3
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<r451@noroute.host>
	aqr_rcpt_idx=2
	aqr_da_idx=0
EOF
  if ${EDBR} ${EDBROPT} > ${EDBROUT} 2>&1
  then
    egrep -v 'tests completed successfully|time|(id|cdb|srv_ip4|aqr_status|state)=' ${EDBROUT} > ${EDBOUT} 2>&1
    if diff ${EDBOUT} ${EDBOK}
    then
      if ${GREP} 'aqr_status=46[578]' ${EDBROUT} >/dev/null
      then
        if ${GREP} 'state=46[578]' ${EDBROUT} >/dev/null
        then
          :
        else
          echo "$0: state check failed"
          ERR=true
        fi
      else
        echo "$0: aqr_status check failed"
        ERR=true
      fi
    else
      echo "$0: edb check failed"
      ERR=true
    fi
  else
    echo "${EDBR} failed"
    ERR=true
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
rm -f ${MTMAP}
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
