#!/bin/sh
# $Id: t-mcpmts-1.sh,v 1.22 2005/10/04 20:36:51 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test program running the full system, uses mcpmts.sh
# runs two SMTP servers
# ----------------------------------------
#
test -s stop && exit 1
#

# source directory of this (and other) shell script
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

# cd to right directory
cd ../qmgr || exit 1
rm -f ${MTMAP}

MSAPORT=2587
export MSAPORT

# create directory to pass socket
if test -d smtps
then
  :
else
  mkdir smtps
fi

# ----------------------------------------
${CAT} >${SMXCNF} <<EOF
smtps MTA { log_level=12; id=0; pass_fd_socket = smtps/mtafd; wait_for_server=4;
	listen_socket { type=inet; port=${SRVPORT}; }
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -N MTA -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtps MSA { log_level=12; id=1; pass_fd_socket = smtps/msafd; wait_for_server=4;
	listen_socket {type=inet;port=${MSAPORT};}
	start_action = pass; user = ${USER};
	path = ../smtps/smtps;
	arguments = "smtps -N MSA -f ${SMXCNF} ${SM_SERVER_OPTIONS}";
}
smtpc { log_level=12; remote_port = ${SNKPORT}; wait_for_server=4;
	start_action = wait; user = ${USER};
	path = "../smtpc/smtpc"; arguments = "smtpc -f ${SMXCNF}";
}
qmgr { log_level = 12;wait_for_server=4; wait_for_client=4; 
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,smtpc,smar, };
	path = "../qmgr/qmgr"; arguments = "qmgr -f ${SMXCNF}";
}
smar { log_level = 12;
	start_action = wait; user = ${USER};
	restart_dependencies = { smtps,qmgr };
	path = "../smar/smar"; arguments = "smar -f ${SMXCNF}";
}
EOF

for i in smar smtpc qmgr MSA MTA
do
  cp /dev/null ${i}.log
done
# ----------------------------------------
${SHELL} ${SD}/mcpmts.sh $@ || exit 1

for i in smar smtpc qmgr MSA MTA
do
  cp /dev/null ${i}.log
done
# ----------------------------------------
${SHELL} ${SD}/mcpmts.sh -E2 -S"a@b.c" -R"x2@y.z" $@ || exit 1

exit 0
