#!/bin/sh
# $Id: t-pm-regex-1.sh,v 1.3 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test milter-regex
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#
if test "X"${SM_PMILTER_REGEX_TEST} = "X"
then
  echo "$0: SKIPPED: SM_PMILTER_REGEX_TEST is not set"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

if ../smtps/smtps -VVV | ${GREP} SM_USE_PMILTER >/dev/null
then
  :
else
  echo "$0: smtps not compiled with SM_USE_PMILTER (--enable-pmilter); test SKIPPED"
  exit 0
fi

PMPRG="../contrib/milter-regex"
if test -x ${PMPRG}
then
  :
else
  echo "$0: ${PMPRG} missing; test SKIPPED"
  exit 0
fi

PMCONF="regex.conf"
PMOPT="-d -c ${PMCONF} -p pmilter.sock"
MSG="t-pm-regex-1.msg"

if test X"`uname`" != "XOSF1"
then
while getopts O:s:V FLAG
do
  case "${FLAG}" in
    O) PMOPT="${PMOPT} ${OPTARG}";;
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 12;
daemon_address = localhost:${SRVPORT};
wait_for_server=4;
policy_milter { socket {type=unix; path="pmilter.sock";} timeout=2; }
}
EOF

# ----------------------------------------
# invalid header, temporary error
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
${CAT} > ${PMCONF} <<EOF
reject "Subject matches word but header is invalid"
header /Subject/ /[[:<:]]word[[:>:]]/e
EOF
${CAT} > ${MSG} <<EOF
From: sender@local.domain
To: rcpt@local.domain
Message-Id: <t-${TEST}-123456789@local.dom>
Subject: this is a word that should be rejected
Reply-To: someone@example.com

t-${TEST}-123456789@local.dom
EOF
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -p ${PMPRG} -P "${PMOPT}" -Z 'smtpc2' -c "-E -D ${MSG}" -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed."
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'DOT=error, text=4' ${CLTL} >/dev/null
then
  if ${GREP} 'sm_xhdr=syntax' ${PML} >/dev/null
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi

# ----------------------------------------
# invalid header, permanent error
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
PMOPT_SAVE="${PMOPT}"
PMOPT="-s ${PMOPT}"
${CAT} > ${PMCONF} <<EOF
reject "Subject matches word but header is invalid"
header /Subject/ /[[:<:]]word[[:>:]]/e
EOF
${CAT} > ${MSG} <<EOF
From: sender@local.domain
To: rcpt@local.domain
Message-Id: <t-${TEST}-123456789@local.dom>
Subject: this is a word that should be rejected
Reply-To: someone@example.com

t-${TEST}-123456789@local.dom
EOF
if ${SHELL} ${SCRIPTS}/smtpcnf.sh -p ${PMPRG} -P "${PMOPT}" -Z 'smtpc2' -c "-E -D ${MSG}" -E 0 -A 0 -X 0 $@ -S"a@b.c" -R"x@y.z"
then
    ERR=false
else
    echo "$0: test ${TEST} failed."
    ERR=true
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'DOT=error, text=5' ${CLTL} >/dev/null
then
  if ${GREP} 'sm_xhdr=syntax' ${PML} >/dev/null
  then
    :
  else
    ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
PMOPT="${PMOPT_SAVE}"
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
