#ifndef _TOK822_H_INCLUDED_
#define _TOK822_H_INCLUDED_

/*++
* NAME
*	tok822 3h
* SUMMARY
*	RFC822 token structures
* SYNOPSIS
*	#include <tok822.h>
* DESCRIPTION
* .nf
*/

/* $Id: tok822.h,v 1.2 2002/03/04 00:27:31 ca Exp $ */

 /*
  * Utility library.
  */
#include "pfxsm/pfxsm.h"

#if 0
 /*
  * Global library.
  */
#include <resolve_clnt.h>
#endif /* 0 */

/* max length of an rfc 822 string */
#define TOK822_MAXLEN	1024

 /*
  * Internal address representation: a token tree.
  */
typedef struct TOK822 {
    int     type;			/* token value, see below */
    VSTRING *vstr;			/* token contents */
    struct TOK822 *prev;		/* peer */
    struct TOK822 *next;		/* peer */
    struct TOK822 *head;		/* group members */
    struct TOK822 *tail;		/* group members */
    struct TOK822 *owner;		/* group owner */
} TOK822;

 /*
  * Token values for multi-character objects. Single-character operators are
  * represented by their own character value.
  */
#define TOK822_MINTOK	256
#define	TOK822_ATOM	256		/* non-special character sequence */
#define	TOK822_QSTRING	257		/* stuff between "", not nesting */
#define	TOK822_COMMENT	258		/* comment including (), may nest */
#define	TOK822_DOMLIT	259		/* stuff between [] not nesting */
#define	TOK822_ADDR	260		/* actually a token group */
#define TOK822_STARTGRP	261		/* start of named group */
#define TOK822_MAXTOK	261

 /*
  * tok822_node.c
  */
TOK822 *tok822_alloc(sm_rpool_P, int , const char *);
extern TOK822 *tok822_free(sm_rpool_P, TOK822 *);

 /*
  * tok822_tree.c
  */
extern TOK822 *tok822_append(TOK822 *, TOK822 *);
extern TOK822 *tok822_prepend(TOK822 *, TOK822 *);
extern TOK822 *tok822_cut_before(TOK822 *);
extern TOK822 *tok822_cut_after(TOK822 *);
extern TOK822 *tok822_unlink(TOK822 *);
extern TOK822 *tok822_sub_append(TOK822 *, TOK822 *);
extern TOK822 *tok822_sub_prepend(TOK822 *, TOK822 *);
extern TOK822 *tok822_sub_keep_before(TOK822 *, TOK822 *);
extern TOK822 *tok822_sub_keep_after(TOK822 *, TOK822 *);
extern TOK822 *tok822_free_tree(sm_rpool_P, TOK822 *);

typedef int (*TOK822_ACTION) (TOK822 *);
extern int tok822_apply(TOK822 *, int, TOK822_ACTION);
extern TOK822 **tok822_grep(sm_rpool_P, TOK822 *, int);

 /*
  * tok822_parse.c
  */
extern TOK822 *tok822_scan(sm_rpool_P, const char *, TOK822 **);
extern TOK822 *tok822_scan_addr(sm_rpool_P, const char *);
extern TOK822 *tok822_parse(sm_rpool_P, const char *);
extern VSTRING *tok822_externalize(VSTRING *, TOK822 *, int);
extern VSTRING *tok822_internalize(VSTRING *, TOK822 *, int);

#define TOK822_STR_NONE	(0)
#define TOK822_STR_WIPE	(1<<0)
#define TOK822_STR_TERM	(1<<1)
#define TOK822_STR_LINE	(1<<2)
#define TOK822_STR_DEFL	(TOK822_STR_WIPE | TOK822_STR_TERM)
#define TOK822_STR_HEAD	(TOK822_STR_TERM | TOK822_STR_LINE)

 /*
  * tok822_find.c
  */
extern TOK822 *tok822_find_type(TOK822 *, int);
extern TOK822 *tok822_rfind_type(TOK822 *, int);

 /*
  * tok822_rewrite.c
  */
extern TOK822 *tok822_rewrite(TOK822 *, const char *);

#if 0
 /*
  * tok822_resolve.c
  */
extern void tok822_resolve(TOK822 *, RESOLVE_REPLY *);
#endif /* 0 */

/* LICENSE
* .ad
* .fi
*	The Secure Mailer license must be distributed with this software.
* AUTHOR(S)
*	Wietse Venema
*	IBM T.J. Watson Research
*	P.O. Box 704
*	Yorktown Heights, NY 10598, USA
*--*/

#endif
