/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: cdb.h,v 1.17 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_CDB_H
#define SM_CDB_H 1

#include "sm/generic.h"
#include "sm/cstr.h"
#include "sm/mta.h"
#include "sm/io.h"

/* CDB context (handle) */
typedef struct cdb_ctx_S	cdb_ctx_T, *cdb_ctx_P;

extern sm_stream_T SmCDBSt;

/* cdb API according to db.func.tex */

#if 0
cdb_start(IN name, IN mode, IN estimated-size, IN hints,
OUT cdb-handle, OUT status):
open a CDB.
mode is read only or read/write (usually the latter).
hints may contain information about the intended (estimated)
usage, e.g., how many mailcontents may be open at the same time.

cdb_open(IN cdb-handle, IN trans-id, IN content-id, IN mode, IN size, IN hints,
OUT status, OUT content-id):
open a content entry.
mode: read or write.
trans-id: transaction id (can be NULL for read,
then content-id must be supplied),
size and hints can be supplied if mode is write.

cdb_write(IN cdb-handle, IN content-id, IN datap, IN len, OUT status, OUT written)

cdb_read(IN cdb-handle, IN content-id, IN datap, IN len, OUT status, OUT read)

cdb_commit(IN cdb-handle, IN content-id, OUT status):
make sure content is on persistent storage.

cdb_close(IN cdb-handle, IN content-id, OUT status).
Should close implicitly call commit?

cdb_abort(IN cdb-handle, IN content-id, OUT status):
obvious meaning.

cdb_unlink(IN cdb-handle, IN content-id, OUT status):
content is not used anymore.

cdb_stop(IN cdb-handle, OUT status):
stop using this CDB.

#endif /* 0 */

/* abstraction layer for cdb */

/*
**  Change this if the cdb_id use/generation changes!
**  Currently SMTPS uses the transaction id as cdb id,
**  see smtps/s2q.c.
**  XXX Maybe add a format specifier to avoid having to change it in
**	print statements when the type is changed?
**  Also add a SM_RCBV_* type?
*/

#define CDB_ID_SIZE SMTP_STID_SIZE
typedef sm_cstr_T	cdb_id_T;
typedef sm_cstr_P	cdb_id_P;

/* coordinate with sm/io.h and search for other SM_IO_WHAT_* */
#define SM_IO_WHAT_CDB_HDL	100	/* pass CDB context (handle) */

#define cdb_open(cdb_handle, trans_id, content_id, mode, size, hints)	\
	sm_io_open(&SmCDBSt, trans_id, mode, &(content_id),	\
		SM_IO_WHAT_CDB_HDL, cdb_handle, SM_IO_WHAT_END)

#define cdb_write(cdb_handle, content_id, datap, len, written)	\
	sm_io_write(content_id, datap, len, written)

#define cdb_commit(cdb_handle, content_id)	\
	sm_io_setinfo(content_id, SM_IO_WHAT_COMMIT, NULL)

#define cdb_close(cdb_handle, content_id) sm_io_close(content_id)

#define cdb_abort(cdb_handle, content_id)	\
		sm_io_setinfo(content_id, SM_IO_WHAT_ABORT, NULL)

#define cdb_unlink(cdb_handle, trans_id)	\
		cdb_remove(cdb_handle, trans_id)

sm_ret_T	 cdb_remove(cdb_ctx_P cdb_ctx, char *_cdb_id);

sm_ret_T	 cdb_start(const char *_base, cdb_ctx_P *_pcdb_ctx);
sm_ret_T	 cdb_end(cdb_ctx_P _cdb_ctx);

#endif /* SM_CDB_H */
