/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: smar.h,v 1.63 2005/08/08 17:23:10 ca Exp $
 */

#ifndef SM_SMAR_H
#define SM_SMAR_H 1

#include "sm/smreplycodes.h"

/*
**  SMAR request flags (SMARRQ_FL_)
**  There are flags used in conjunction with "routing" lookups
**  for recipient addresses (used by qmgr to get rcpt destinations).
*/

/* normal request */
#define SMARRQ_FL_NONE		0x0000

/* do also alias expansion */
#define SMARRQ_FL_ALIAS		0x0001

/* check owner- */
#define SMARRQ_FL_OWNER		0x0002

/* check local addresses */
#define SMARRQ_FL_CHK_LU	0x0004

/* do not expand aliases/rcpt, just check */
#define SMARRQ_FL_NOEXP		0x0010

/* do not cut MX list at "local" names */
#define SMARRQ_FL_NOMXCUT	0x0020
/* -------------------- */

/*
**  SMAR addr lookup flags (SMARA_LFL_)
**  These flags are used for various anti-spam lookups (by smtps)
**  to specify the kind of data.
*/

#define SMARA_LFL_NONE		0x00000000

/* RFC 2821 address */
#define SMARA_LFL_2821		0x00000001

/* hostname */
#define SMARA_LFL_HOST		0x00000002

/* IPv4 address */
#define SMARA_LFL_IPV4		0x00000004

/* IPv6 address */
/*#define SMARA_LFL_IPV6	0x00000008 */

/* lookup also domain of RFC 2821 address */
#define SMARA_LFL_DOM		0x00000010	/* unused */

/* lookup also subnets/domains */
#define SMARA_LFL_SUB		0x00000020

/* reverse lookup for IPv4 address */
#define SMARA_LFL_RVRS4		0x00000100

/* check reverse lookup against access map */
#define SMARA_LFL_RVACC		0x00000200

/* check MX/IP addresses against access map */
#define SMARA_LFL_MXACC		0x00000400


/* DNS blocklist lookup for IPv4 address */
#define SMARA_LFL_DNSBL		0x00001000

/* cert (currently an "opaque" string) */
#define SMARA_LFL_CERT		0x00002000

/* use string map for protected recipient lookups */
#define SMARA_LFL_PROTMAP	0x00004000

/* implicitly match +detail */
#define SMARA_LFL_PROTIMPLDET	0x00008000

/* implicitly match +detail */
#define SMARA_LFL_ACCIMPLDET	0x00010000
/* #define SMARA_LFL_ALIIMPLDET	0x00020000 */
/* #define SMARA_LFL_LUMIMPLDET	0x00040000 */

/* #define SMARA_LFL_WOD	0x00010000	* lookup without detail */
/* #define SMARA_LFL_WDW	0x00020000	* lookup with detail wildcard */
/* -------------------- */

/*
**  SMAR addr lookup type (SMARA_LT_)
**  What lookups should be performed for "addresses"?
*/

#define SMARA_LT_NONE		0x0000
#define SMARA_LT_RCPT_LOCAL	0x0001	/* rcpt local? check in table */
#define SMARA_LT_RCPT_ACC	0x0002	/* check rcpt in access map */
#define SMARA_LT_MAIL_ACC	0x0004	/* check mail in access map */
#define SMARA_LT_CLT_A_ACC	0x0008	/* check client address */
#define SMARA_LT_CLT_N_ACC	0x0010	/* check client hostname */
#define SMARA_LT_IPV4		0x0020	/* check IPv4 address */
#define SMARA_LT_MAIL_ROUTE	0x0040	/* check whether mail can be routed */
#define SMARA_LT_MAIL_LOCAL	0x0080	/* mail local? check in table */
#define SMARA_LT_RCPT_RELAY	0x0100	/* relaying to rcpt allowed? */
#define SMARA_LT_CLT_RELAY	0x0200	/* relaying from client IP allowed? */
#define SMARA_LT_RCPT_LCL_R	0x0400	/* set return flag if rcpt local */
#define SMARA_LT_CERT_RELAY	0x0800	/* cert lookup for relaying */
#define SMARA_LT_RCPT_PROT	0x1000	/* check whether rcpt is "protected" */
#define SMARA_LT_GREY		0x2000	/* perform greylistng */
#define SMARA_LT_RVRS_N_ACC	0x4000	/* check resolved hostname */
/* -------------------- */

/* results of reverse/forward lookup */
/* forward matches original address */
#define SM_RVRS_MATCH		1

/* none of the forward lookups matches address */
#define SM_RVRS_NOMATCH		2

/* temporary error while resolving PTR record */
#define SM_RVRS_TEMP_PTR	4

/* temporary error while resolving A record */
#define SM_RVRS_TEMP_A		8
/* -------------------- */

/*
**  A result from SMAR can return additional flags,
**  the lower 16 bits are reserved for a "normal" return value;
**  those are defined in sm/smreplycodes.h (with which these MUST be
**  coordinated) "enhanced" SMTP reply codes SMTP_R_*;
**  the rest is for flags.
*/

#define SMAR_R_QUICK	SMTP_R_QUICK	/* "QUICK" flag */
#define SMAR_R_DELAY	0x00020000	/* "DELAY" flag */
#define SMAR_R_LOC_RCPT	0x00040000	/* recipient is local */
#define SMAR_R_GREY	SMTP_R_GREY	/* "GREY" flag */

#define SMAR_R_SET(v, flags)	(v) |= (flags)
#define SMAR_R_CLR(v, flags)	(v) &= ~(flags)
#define SMAR_R_IS(v, flags)	(((v) & (flags)) != 0)

/* check whether it is QUICK result */
#define SMAR_RISQUICK(ret)	(((ret) & SMAR_R_QUICK) != 0)
#define SMAR_RCLRQUICK(v)	SMAR_R_CLR(v, SMAR_R_QUICK)

/* check whether it is DELAY result */
#define SMAR_RISDELAY(ret)	(((ret) & SMAR_R_DELAY) != 0)
#define SMAR_RCLRDELAY(v)	SMAR_R_CLR(v, SMAR_R_DELAY)

/* check whether it is GREY result */
#define SMAR_RISGREY(ret)	(((ret) & SMAR_R_GREY) != 0)
#define SMAR_RCLRGREY(v)	SMAR_R_CLR(v, SMAR_R_GREY)

/* -------------------- */

#define SMAR_R_FL_MASK	0x7fff0000
#define SMAR_R_VAL_MASK	0x00007fff

/* get result without flags */
#define SMAR_RWOFLAGS(ret)	((ret) & SMAR_R_VAL_MASK)
#define SMAR_CLRFLAGS(ret)	(ret) = SMAR_RWOFLAGS(ret)

#define SMAR_R_VAL(v)	((v) & SMAR_R_VAL_MASK)
#define SMAR_R_FLAGS(v)	((v) & SMAR_R_FL_MASK)

/* access map lookup return values */
#define SM_ACC_FOUND	1
#define SM_ACC_NOTFOUND	SM_SUCCESS
#define SM_ACC_TEMPFAIL	SM_MAP_TEMPMAP
#define SM_ACC_PERMFAIL	SM_MAP_PERMMAP
/* -------------------- */

#endif /* SM_SMAR_H */
