/*
 * Copyright (c) 2000-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: string.h,v 1.20 2005/09/02 19:53:00 ca Exp $
 */

#ifndef SM_STRING_H
#define SM_STRING_H 1

#include "sm/generic.h"
#include "sm/varargs.h"

/* return number of bytes left in a buffer */
#define SPACELEFT(buf, ptr)	(sizeof buf - ((ptr) - buf))

int PRINTFLIKE(3, 4)
sm_snprintf(char *, size_t, const char *, ...);

#if !HAVE_STRLCPY
size_t strlcpy(char *_dst, const char *_src, size_t _len);
#endif
#if !HAVE_STRLCAT
size_t strlcat(char *_dst, const char *_src, size_t _len);
#endif
#if !HAVE_STRSEP || NEED_STRSEP_PROTO
char *strsep(char **_stringp, const char *_delim);
#endif

#if 0
bool sm_match(const char *_str, const char *_pattern);
char *sm_strdup(char *);
size_t sm_strlcat2(char *, const char *, const char *, ssize_t);

size_t
#ifdef __STDC__
sm_strlcpyn(char *dst, ssize_t len, int n, ...);
#else
sm_strlcpyn(char *, ssize_t, int, va_dcl);
#endif

#if !HASSTRERROR
char *strerror(int _errno);
#endif
#if HAVE_STRERROR_R && !HAVE_DECL_STRERROR_R
# if HAVE_WORKING_STRERROR_R
char *strerror_r(int _errnum, char *_strerrbuf, size_t _buflen);
# else
int strerror_r(int _errnum, char *_strerrbuf, size_t _buflen);
# endif
#endif


int	sm_strrevcmp(const char *, const char *);
int	sm_strrevcasecmp(const char *, const char *);
int	sm_strcasecmp(const char *, const char *);
int	sm_strncasecmp(const char *, const char *, size_t);
void	stripquotes(char *);

#endif /* 0 */

longlong_T	sm_strtoll(const char *, char**, int);
ulonglong_T	sm_strtoull(const char *, char**, int);

#define sm_streqn(s1, s2, l)	(strncmp((s1), (s2), (l)) == 0)
#define sm_streq(s1, s2)	(strcmp((s1), (s2)) == 0)
#define sm_strcaseeqn(s1, s2, l) (strncasecmp((s1), (s2), (l)) == 0)
#define sm_strcaseeq(s1, s2)	(strcasecmp((s1), (s2)) == 0)

char	*sm_getnextstring(char **_cpp);

#endif /* SM_STRING_H */
