/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: tlsbio.h,v 1.3 2005/06/16 00:09:35 ca Exp $
 */

#ifndef SM_TLSBIO_H
#define SM_TLSBIO_H 1
#include "sm/generic.h"
#include "sm/types.h"
#include "sm/io.h"

#if SM_USE_TLS

typedef int (hsfunc_F)(SSL *);
typedef int (rfunc_F)(SSL *, void *, int);
typedef int (wfunc_F)(SSL *, const void *, int);

int	 do_tls_operation(sm_file_T *fp,
		 	hsfunc_F *hsfunc, rfunc_F *rfunc, wfunc_F *wfunc,
		 	uchar *buf, int num, ssize_t *bytes);

sm_ret_T tls_open(sm_file_T *_fp, SSL *_con, sm_file_T **_newfp);

#endif /* SM_USE_TLS */

#endif /* SM_TLSBIO_H */
