/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: prtbuf.c,v 1.2 2004/12/02 00:34:03 ca Exp $")
#include "sm/check.h"

#include <stdio.h>

void
prtbuf(FILE *fp, char *buf, size_t len)
{
	size_t i;
	int c;

	for (i = 0; i < len; i++)
	{
		c = (int) (buf[i] & 0xff);
		if (ISPRINT(c) || c == '\n' || c == '\r')
			fputc(c, fp);
		else
			fprintf(fp, " %02x ", c);
	}
}

