/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: smtlsi.c,v 1.2 2004/11/12 22:05:37 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/tls.h"

#if SM_USE_TLS

/*
**  TLSI_NEW -- allocate new TLS information context
**
**	Parameters:
**		ptlsi_ctx -- (pointer to) TLS information context (output)
**
**	Returns:
**		usual error code
*/

sm_ret_T
tlsi_new(tlsi_ctx_P *ptlsi_ctx)
{
	tlsi_ctx_P tlsi_ctx;

	SM_REQUIRE(ptlsi_ctx != NULL);
	*ptlsi_ctx = NULL;
	tlsi_ctx = (tlsi_ctx_P) sm_zalloc(sizeof(*tlsi_ctx));
	if (tlsi_ctx == NULL)
		return sm_error_temp(SM_EM_TLS, ENOMEM);
	*ptlsi_ctx = tlsi_ctx;

	tlsi_ctx->tlsi_vrfy = TLS_VRFY_NONE;
	tlsi_ctx->tlsi_cipher_bits = -1;
	tlsi_ctx->tlsi_algs_bits = -1;

	/* allocate strings here? */

	return SM_SUCCESS;
}

/*
**  TLSI_FREE -- free TLS information context
**
**	Parameters:
**		tlsi_ctx -- TLS information context
**
**	Returns:
**		usual error code (SUCCESS)
*/

sm_ret_T
tlsi_free(tlsi_ctx_P tlsi_ctx)
{
	if (tlsi_ctx != NULL)
	{
		SM_STR_FREE(tlsi_ctx->tlsi_cipher);
		SM_STR_FREE(tlsi_ctx->tlsi_version);
		SM_STR_FREE(tlsi_ctx->tlsi_cert_subject);
		SM_STR_FREE(tlsi_ctx->tlsi_cert_issuer);
		SM_STR_FREE(tlsi_ctx->tlsi_cn_subject);
#if SM_TLSI_CERT_MD5
		SM_STR_FREE(tlsi_ctx->tlsi_cert_md5);
#endif
		SM_STR_FREE(tlsi_ctx->tlsi_cn_issuer);
		sm_free_size(tlsi_ctx, sizeof(*tlsi_ctx));
	}
	return SM_SUCCESS;
}

/*
**  TLSI_CLR -- clear TLS information context
**
**	Parameters:
**		tlsi_ctx -- TLS information context
**
**	Returns:
**		usual error code (SUCCESS)
*/

sm_ret_T
tlsi_clr(tlsi_ctx_P tlsi_ctx)
{
	if (tlsi_ctx == NULL)
		return SM_SUCCESS;

	tlsi_ctx->tlsi_vrfy = TLS_VRFY_NONE;
	tlsi_ctx->tlsi_cipher_bits = -1;
	tlsi_ctx->tlsi_algs_bits = -1;

	SM_STR_CLR(tlsi_ctx->tlsi_cipher);
	SM_STR_CLR(tlsi_ctx->tlsi_version);
	SM_STR_CLR(tlsi_ctx->tlsi_cert_subject);
	SM_STR_CLR(tlsi_ctx->tlsi_cert_issuer);
	SM_STR_CLR(tlsi_ctx->tlsi_cn_subject);
	SM_STR_CLR(tlsi_ctx->tlsi_cn_issuer);
#if SM_TLSI_CERT_MD5
	SM_STR_CLR(tlsi_ctx->tlsi_cert_md5);
#endif
	return SM_SUCCESS;
}

#endif /* SM_USE_TLS */
